/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server.event;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.eureka.server.advice.LeaseManagerLite;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceCanceledEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRenewedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class LeaseManagerMessageBroker
implements LeaseManagerLite<InstanceInfo> {
    private static final Logger logger = LoggerFactory.getLogger(LeaseManagerMessageBroker.class);
    @Autowired
    private ApplicationContext ctxt;

    @Override
    public void register(InstanceInfo info, boolean isReplication) {
        this.register(info, 90, isReplication);
    }

    public void register(InstanceInfo info, int leaseDuration, boolean isReplication) {
        logger.debug("register {}, vip {}, leaseDuration {}, isReplication {}", new Object[]{info.getAppName(), info.getVIPAddress(), leaseDuration, isReplication});
        this.ctxt.publishEvent((ApplicationEvent)new EurekaInstanceRegisteredEvent(this, info, leaseDuration, isReplication));
    }

    public boolean cancel(String appName, String serverId, boolean isReplication) {
        logger.debug("cancel {}, serverId {}, isReplication {}", new Object[]{appName, serverId, isReplication});
        this.ctxt.publishEvent((ApplicationEvent)new EurekaInstanceCanceledEvent(this, appName, serverId, isReplication));
        return false;
    }

    public boolean renew(final String appName, final String serverId, boolean isReplication) {
        logger.debug("renew {}, serverId {}, isReplication {}", new Object[]{appName, serverId, isReplication});
        List applications = PeerAwareInstanceRegistry.getInstance().getSortedApplications();
        Optional app = Iterables.tryFind((Iterable)applications, (Predicate)new Predicate<Application>(){

            public boolean apply(@Nullable Application input) {
                return input.getName().equals(appName);
            }
        });
        if (app.isPresent()) {
            Optional info = Iterables.tryFind((Iterable)((Application)app.get()).getInstances(), (Predicate)new Predicate<InstanceInfo>(){

                public boolean apply(@Nullable InstanceInfo input) {
                    return input.getHostName().equals(serverId);
                }
            });
            this.ctxt.publishEvent((ApplicationEvent)new EurekaInstanceRenewedEvent(this, appName, serverId, (InstanceInfo)info.orNull(), isReplication));
        }
        return false;
    }

    public void evict() {
    }
}

