/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.ribbon;

import com.netflix.client.config.IClientConfigKey;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.springframework.cloud.kubernetes.ribbon.Types;
import org.springframework.util.Assert;

public abstract class KubernetesConfigKey<T>
implements IClientConfigKey<T> {
    public static final IClientConfigKey<String> Namespace = new KubernetesConfigKey<String>("KubernetesNamespace"){};
    public static final IClientConfigKey<String> PortName = new KubernetesConfigKey<String>("PortName"){};
    private static final Set<IClientConfigKey> keys = new HashSet<IClientConfigKey>();
    private final String configKey;
    private final Class<T> type;

    protected KubernetesConfigKey(String configKey) {
        this.configKey = configKey;
        Type superclass = this.getClass().getGenericSuperclass();
        Assert.isTrue((boolean)(superclass instanceof ParameterizedType), (String)(superclass + " isn't parameterized"));
        Type runtimeType = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.type = Types.rawType(runtimeType);
    }

    @Deprecated
    public static IClientConfigKey[] values() {
        return KubernetesConfigKey.keys().toArray(new IClientConfigKey[0]);
    }

    public static Set<IClientConfigKey> keys() {
        return keys;
    }

    public static IClientConfigKey valueOf(final String name) {
        for (IClientConfigKey key : KubernetesConfigKey.keys()) {
            if (!key.key().equals(name)) continue;
            return key;
        }
        return new IClientConfigKey(){

            public String key() {
                return name;
            }

            public Class type() {
                return String.class;
            }
        };
    }

    public Class<T> type() {
        return this.type;
    }

    public String key() {
        return this.configKey;
    }

    public String toString() {
        return this.configKey;
    }

    static {
        for (Field f : KubernetesConfigKey.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !IClientConfigKey.class.isAssignableFrom(f.getType())) continue;
            try {
                keys.add((IClientConfigKey)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

