/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.discovery.EndpointSubsetNS;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryServicesAdapter;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8KubernetesDiscoveryClientUtils;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8ServicePortData;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.fabric8.discovery.ServicePortSecureResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;

public class KubernetesDiscoveryClient
implements DiscoveryClient,
EnvironmentAware {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesDiscoveryClient.class));
    private final KubernetesDiscoveryProperties properties;
    private final KubernetesClientServicesFunction kubernetesClientServicesFunction;
    private final ServicePortSecureResolver servicePortSecureResolver;
    private final Fabric8DiscoveryServicesAdapter adapter;
    private KubernetesClient client;
    private KubernetesNamespaceProvider namespaceProvider;

    public KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction) {
        this(client, kubernetesDiscoveryProperties, kubernetesClientServicesFunction, null, new ServicePortSecureResolver(kubernetesDiscoveryProperties));
    }

    KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction, Predicate<Service> filter, ServicePortSecureResolver servicePortSecureResolver) {
        this.client = client;
        this.properties = kubernetesDiscoveryProperties;
        this.servicePortSecureResolver = servicePortSecureResolver;
        this.kubernetesClientServicesFunction = kubernetesClientServicesFunction;
        this.adapter = new Fabric8DiscoveryServicesAdapter(kubernetesClientServicesFunction, kubernetesDiscoveryProperties, filter);
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String description() {
        return "Fabric8 Kubernetes Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId);
        List<EndpointSubsetNS> subsetsNS = this.getEndPointsList(serviceId).stream().map(Fabric8KubernetesDiscoveryClientUtils::subsetsFromEndpoints).toList();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (EndpointSubsetNS es : subsetsNS) {
            instances.addAll(this.getNamespaceServiceInstances(es, serviceId));
        }
        if (this.properties.includeExternalNameServices()) {
            LOG.debug(() -> "Searching for 'ExternalName' type of services with serviceId : " + serviceId);
            List<Service> services = Fabric8KubernetesDiscoveryClientUtils.services(this.properties, this.client, this.namespaceProvider, s -> s.getSpec().getType().equals("ExternalName"), Map.of("metadata.name", serviceId), "fabric8-discovery");
            for (Service service : services) {
                Map<String, String> serviceMetadata = Fabric8KubernetesDiscoveryClientUtils.serviceMetadata(serviceId, service, this.properties, List.of(), service.getMetadata().getNamespace());
                ServiceInstance externalNameServiceInstance = Fabric8KubernetesDiscoveryClientUtils.serviceInstance(null, service, null, new Fabric8ServicePortData(-1, null), serviceId, serviceMetadata, service.getMetadata().getNamespace(), this.properties, this.client);
                instances.add(externalNameServiceInstance);
            }
        }
        return instances;
    }

    public List<Endpoints> getEndPointsList(String serviceId) {
        return Fabric8KubernetesDiscoveryClientUtils.endpoints(this.properties, this.client, this.namespaceProvider, "fabric8-discovery", serviceId, this.adapter.filter());
    }

    private List<ServiceInstance> getNamespaceServiceInstances(EndpointSubsetNS es, String serviceId) {
        List<EndpointSubset> subsets = es.endpointSubset();
        if (subsets.isEmpty()) {
            LOG.debug(() -> "serviceId : " + serviceId + " does not have any subsets");
            return List.of();
        }
        String namespace = es.namespace();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceId)).get();
        Map<String, String> serviceMetadata = Fabric8KubernetesDiscoveryClientUtils.serviceMetadata(serviceId, service, this.properties, subsets, namespace);
        for (EndpointSubset endpointSubset : subsets) {
            Fabric8ServicePortData portData = Fabric8KubernetesDiscoveryClientUtils.endpointsPort(endpointSubset, serviceId, this.properties, service);
            List<EndpointAddress> addresses = Fabric8KubernetesDiscoveryClientUtils.addresses(endpointSubset, this.properties);
            for (EndpointAddress endpointAddress : addresses) {
                ServiceInstance serviceInstance = Fabric8KubernetesDiscoveryClientUtils.serviceInstance(this.servicePortSecureResolver, service, endpointAddress, portData, serviceId, serviceMetadata, namespace, this.properties, this.client);
                instances.add(serviceInstance);
            }
        }
        return instances;
    }

    public List<String> getServices() {
        return this.adapter.apply(this.client).stream().map(s -> s.getMetadata().getName()).distinct().toList();
    }

    @Deprecated(forRemoval=true)
    public List<String> getServices(Predicate<Service> filter) {
        return new Fabric8DiscoveryServicesAdapter(this.kubernetesClientServicesFunction, this.properties, filter).apply(this.client).stream().map(s -> s.getMetadata().getName()).distinct().toList();
    }

    public int getOrder() {
        return this.properties.order();
    }

    @Deprecated(forRemoval=true)
    public final void setEnvironment(Environment environment) {
        this.namespaceProvider = new KubernetesNamespaceProvider(environment);
    }
}

