/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.discovery.v1.Endpoint;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8CatalogWatchContext;
import org.springframework.core.log.LogAccessor;

final class Fabric8EndpointSliceV1CatalogWatch
implements Function<Fabric8CatalogWatchContext, List<EndpointNameAndNamespace>> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8EndpointSliceV1CatalogWatch.class));

    Fabric8EndpointSliceV1CatalogWatch() {
    }

    @Override
    public List<EndpointNameAndNamespace> apply(Fabric8CatalogWatchContext context) {
        List<EndpointSlice> endpointSlices;
        KubernetesClient client = context.kubernetesClient();
        if (context.properties().allNamespaces()) {
            LOG.debug(() -> "discovering endpoints in all namespaces");
            endpointSlices = ((EndpointSliceList)((FilterWatchListDeletable)((AnyNamespaceOperation)client.discovery().v1().endpointSlices().inAnyNamespace()).withLabels(context.properties().serviceLabels())).list()).getItems();
        } else if (!context.properties().namespaces().isEmpty()) {
            LOG.debug(() -> "discovering endpoints in " + context.properties().namespaces());
            ArrayList<EndpointSlice> inner = new ArrayList<EndpointSlice>(context.properties().namespaces().size());
            context.properties().namespaces().forEach(namespace -> inner.addAll(this.endpointSlices(context, (String)namespace, client)));
            endpointSlices = inner;
        } else {
            String namespace2 = Fabric8Utils.getApplicationNamespace((KubernetesClient)context.kubernetesClient(), null, (String)"catalog-watcher", (KubernetesNamespaceProvider)context.namespaceProvider());
            LOG.debug(() -> "discovering endpoints in namespace : " + namespace2);
            endpointSlices = this.endpointSlices(context, namespace2, client);
        }
        Stream<ObjectReference> references = endpointSlices.stream().map(EndpointSlice::getEndpoints).flatMap(Collection::stream).map(Endpoint::getTargetRef);
        return Fabric8CatalogWatchContext.state(references);
    }

    private List<EndpointSlice> endpointSlices(Fabric8CatalogWatchContext context, String namespace, KubernetesClient client) {
        return ((EndpointSliceList)((FilterWatchListDeletable)((NonNamespaceOperation)client.discovery().v1().endpointSlices().inNamespace(namespace)).withLabels(context.properties().serviceLabels())).list()).getItems();
    }
}

