/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8;

import io.fabric8.kubernetes.api.model.Pod;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.fabric8.Fabric8HealthIndicator;
import org.springframework.cloud.kubernetes.fabric8.Fabric8InfoContributor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
public class Fabric8ActuatorConfiguration {
    @Bean
    @ConditionalOnEnabledHealthIndicator(value="kubernetes")
    public Fabric8HealthIndicator kubernetesHealthIndicator(PodUtils<Pod> podUtils) {
        return new Fabric8HealthIndicator(podUtils);
    }

    @Bean
    @ConditionalOnEnabledInfoContributor(value="kubernetes")
    public Fabric8InfoContributor kubernetesInfoContributor(PodUtils<Pod> podUtils) {
        return new Fabric8InfoContributor(podUtils);
    }
}

