/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.config.ConfigUtils;
import org.springframework.cloud.kubernetes.config.PropertySourceUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=0)
public class ConfigMapPropertySourceLocator
implements PropertySourceLocator {
    private static final Log LOG = LogFactory.getLog(ConfigMapPropertySourceLocator.class);
    private final KubernetesClient client;
    private final ConfigMapConfigProperties properties;

    public ConfigMapPropertySourceLocator(KubernetesClient client, ConfigMapConfigProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public PropertySource locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            List<ConfigMapConfigProperties.NormalizedSource> sources = this.properties.determineSources();
            CompositePropertySource composite = new CompositePropertySource("composite-configmap");
            if (this.properties.isEnableApi()) {
                sources.forEach(s -> composite.addFirstPropertySource((PropertySource)this.getMapPropertySourceForSingleConfigMap(env, (ConfigMapConfigProperties.NormalizedSource)s)));
            }
            this.addPropertySourcesFromPaths(environment, composite);
            return composite;
        }
        return null;
    }

    private MapPropertySource getMapPropertySourceForSingleConfigMap(ConfigurableEnvironment environment, ConfigMapConfigProperties.NormalizedSource normalizedSource) {
        String configurationTarget = this.properties.getConfigurationTarget();
        return new ConfigMapPropertySource(this.client, ConfigUtils.getApplicationName((Environment)environment, normalizedSource.getName(), configurationTarget), ConfigUtils.getApplicationNamespace(this.client, normalizedSource.getNamespace(), configurationTarget), (Environment)environment);
    }

    private void addPropertySourcesFromPaths(Environment environment, CompositePropertySource composite) {
        this.properties.getPaths().stream().map(x$0 -> Paths.get(x$0, new String[0])).peek(p -> {
            if (!Files.exists(p, new LinkOption[0])) {
                LOG.warn((Object)("Configured input path: " + p + " will be ignored because it does not exist on the file system"));
            }
        }).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).peek(p -> {
            if (!Files.isRegularFile(p, new LinkOption[0])) {
                LOG.warn((Object)("Configured input path: " + p + " will be ignored because it is not a regular file"));
            }
        }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
            try {
                String content = new String(Files.readAllBytes(p)).trim();
                String filename = p.getFileName().toString().toLowerCase();
                if (filename.endsWith(".properties")) {
                    this.addPropertySourceIfNeeded((Function<String, Map<String, String>>)((Function)c -> PropertySourceUtils.PROPERTIES_TO_MAP.apply(PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.apply((String)c))), content, filename, composite);
                } else if (filename.endsWith(".yml") || filename.endsWith(".yaml")) {
                    this.addPropertySourceIfNeeded((Function<String, Map<String, String>>)((Function)c -> PropertySourceUtils.PROPERTIES_TO_MAP.apply(PropertySourceUtils.yamlParserGenerator(environment).apply((String)c))), content, filename, composite);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Error reading input file", (Throwable)e);
            }
        });
    }

    private void addPropertySourceIfNeeded(Function<String, Map<String, String>> contentToMapFunction, String content, String name, CompositePropertySource composite) {
        HashMap map = new HashMap();
        map.putAll((Map)contentToMapFunction.apply((Object)content));
        if (map.isEmpty()) {
            LOG.warn((Object)("Property source: " + name + "will be ignored because no properties could be found"));
        } else {
            composite.addFirstPropertySource((PropertySource)new MapPropertySource(name, map));
        }
    }
}

