/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.MapPropertySource;

public class KubernetesPropertySource
extends MapPropertySource {
    private static final Log LOG = LogFactory.getLog(KubernetesPropertySource.class);

    protected KubernetesPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    protected static void putPathConfig(Map<String, ? super String> result, List<String> paths) {
        paths.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(p -> KubernetesPropertySource.putAll(p, result));
    }

    private static void putAll(Path path, Map<String, ? super String> result) {
        try {
            Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> KubernetesPropertySource.readFile(p, result));
        }
        catch (IOException e) {
            LOG.warn((Object)"Error walking properties files", (Throwable)e);
        }
    }

    private static void readFile(Path path, Map<String, ? super String> result) {
        try {
            result.put(path.getFileName().toString(), new String(Files.readAllBytes(path)).trim());
        }
        catch (IOException e) {
            LOG.warn((Object)"Error reading properties file", (Throwable)e);
        }
    }
}

