/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.discovery;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortNameAndNumber;
import org.springframework.core.log.LogAccessor;

public final class ServicePortSecureResolver {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ServicePortSecureResolver.class));
    private static final Set<String> TRUTHY_STRINGS = Set.of("true", "on", "yes", "1");
    private final KubernetesDiscoveryProperties properties;

    public ServicePortSecureResolver(KubernetesDiscoveryProperties properties) {
        this.properties = properties;
    }

    public boolean resolve(Input input) {
        String serviceName = input.serviceName();
        ServicePortNameAndNumber portData = input.portData();
        Optional<String> securedLabelValue = Optional.ofNullable(input.serviceLabels().get("secured"));
        if (securedLabelValue.isPresent() && TRUTHY_STRINGS.contains(securedLabelValue.get())) {
            ServicePortSecureResolver.logEntry(serviceName, portData.portNumber(), "the service contains a true value for the 'secured' label");
            return true;
        }
        Optional<String> securedAnnotationValue = Optional.ofNullable(input.serviceAnnotations().get("secured"));
        if (securedAnnotationValue.isPresent() && TRUTHY_STRINGS.contains(securedAnnotationValue.get())) {
            ServicePortSecureResolver.logEntry(serviceName, portData.portNumber(), "the service contains a true value for the 'secured' annotation");
            return true;
        }
        if (this.properties.knownSecurePorts().contains(portData.portNumber())) {
            ServicePortSecureResolver.logEntry(serviceName, portData.portNumber(), "port is known to be a https port");
            return true;
        }
        if ("https".equalsIgnoreCase(input.portData().portName())) {
            ServicePortSecureResolver.logEntry(serviceName, portData.portNumber(), "port-name is 'https'");
            return true;
        }
        return false;
    }

    private static void logEntry(String serviceName, Integer port, String reason) {
        LOG.debug(() -> "Considering service with name: " + serviceName + " and port " + port + " to be secure since " + reason);
    }

    public record Input(ServicePortNameAndNumber portData, String serviceName, Map<String, String> serviceLabels, Map<String, String> serviceAnnotations) {
        public Input(ServicePortNameAndNumber portData, String serviceName, Map<String, String> serviceLabels, Map<String, String> serviceAnnotations) {
            this.portData = portData;
            this.serviceName = serviceName;
            this.serviceLabels = serviceLabels == null ? Map.of() : serviceLabels;
            this.serviceAnnotations = serviceAnnotations == null ? Map.of() : serviceAnnotations;
        }
    }
}

