/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.webflux.config;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.webflux.config.ProxyExchangeArgumentResolver;
import org.springframework.cloud.gateway.webflux.config.ProxyProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={HandlerMethodReturnValueHandler.class})
@EnableConfigurationProperties(value={ProxyProperties.class})
public class ProxyResponseAutoConfiguration
implements WebFluxConfigurer {
    @Autowired
    private ApplicationContext context;

    @Bean
    @ConditionalOnMissingBean
    public ProxyExchangeArgumentResolver proxyExchangeArgumentResolver(Optional<WebClient.Builder> optional, ProxyProperties proxy) {
        WebClient.Builder builder = optional.orElse(WebClient.builder());
        WebClient template = builder.build();
        ProxyExchangeArgumentResolver resolver = new ProxyExchangeArgumentResolver(template);
        resolver.setHeaders(proxy.convertHeaders());
        resolver.setSensitive(proxy.getSensitive());
        return resolver;
    }

    public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
        super.configureArgumentResolvers(configurer);
        configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{(HandlerMethodArgumentResolver)this.context.getBean(ProxyExchangeArgumentResolver.class)});
    }
}

