/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.config;

import org.springframework.cloud.gateway.support.config.KeyValue;
import org.springframework.core.convert.converter.Converter;

public class KeyValueConverter
implements Converter<String, KeyValue> {
    private static final String INVALID_CONFIGURATION_MESSAGE = "Invalid configuration, expected format is: 'key:value', received: ";

    public KeyValue convert(String source) throws IllegalArgumentException {
        try {
            String[] split = source.split(":");
            if (split.length == 2) {
                return new KeyValue(split[0], split.length == 1 ? "" : split[1]);
            }
            throw new IllegalArgumentException(INVALID_CONFIGURATION_MESSAGE + source);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(INVALID_CONFIGURATION_MESSAGE + source);
        }
    }
}

