/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.function;

import java.util.Set;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.web.RequestProcessor;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class FunctionEndpointFactory {
    private static Log logger = LogFactory.getLog(FunctionEndpointFactory.class);
    private Function<Flux<?>, Flux<?>> function;
    private FunctionInspector inspector;
    private RequestProcessor processor;

    FunctionEndpointFactory(FunctionCatalog catalog, FunctionInspector inspector, RequestProcessor processor, Environment environment) {
        String handler = environment.resolvePlaceholders("${function.handler}");
        if (handler.startsWith("$")) {
            handler = null;
        }
        this.processor = processor;
        this.inspector = inspector;
        this.function = this.extract(catalog, handler);
    }

    private Function<Flux<?>, Flux<?>> extract(FunctionCatalog catalog, String handler) {
        Set names = catalog.getNames(Function.class);
        if (!names.isEmpty()) {
            logger.info((Object)("Found functions: " + names));
            if (handler != null) {
                logger.info((Object)("Configured function: " + handler));
                Assert.isTrue((boolean)names.contains(handler), (String)("Cannot locate function: " + handler));
                return (Function)catalog.lookup(Function.class, handler);
            }
            return (Function)catalog.lookup(Function.class, (String)names.iterator().next());
        }
        throw new IllegalStateException("No function defined");
    }

    public <T> RouterFunction<?> functionEndpoints() {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.POST((String)"/"), request -> {
            Class outputType = this.inspector.getOutputType(this.function);
            RequestProcessor.FunctionWrapper wrapper = RequestProcessor.wrapper(this.function, null, null);
            Mono stream = request.bodyToMono(String.class).flatMap(content -> this.processor.post(wrapper, (String)content, false));
            return stream.flatMap(entity -> ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatus)entity.getStatusCode()).headers(headers -> headers.addAll((MultiValueMap)entity.getHeaders()))).body((Publisher)Mono.just((Object)entity.getBody()), outputType));
        });
    }
}

