/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.function.web.RequestProcessor;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class FunctionController {
    private RequestProcessor processor;

    public FunctionController(RequestProcessor processor) {
        this.processor = processor;
    }

    @PostMapping(path={"/**"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public Mono<ResponseEntity<?>> form(ServerWebExchange request) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return request.getFormData().doOnSuccess(params -> wrapper.params((MultiValueMap<String, String>)params)).then(Mono.defer(() -> this.processor.post(wrapper, null, false)));
    }

    @PostMapping(path={"/**"}, consumes={"multipart/form-data"})
    @ResponseBody
    public Mono<ResponseEntity<?>> multipart(ServerWebExchange request) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return request.getMultipartData().doOnSuccess(params -> wrapper.params(this.multi((MultiValueMap<String, Part>)params))).then(Mono.defer(() -> this.processor.post(wrapper, null, false)));
    }

    private MultiValueMap<String, String> multi(MultiValueMap<String, Part> body) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (String key : body.keySet()) {
            for (Part part : (List)body.get((Object)key)) {
                if (!(part instanceof FormFieldPart)) continue;
                FormFieldPart form = (FormFieldPart)part;
                map.add((Object)key, (Object)form.value());
            }
        }
        return map;
    }

    @PostMapping(path={"/**"}, consumes={"application/octet-stream"})
    @ResponseBody
    public Mono<ResponseEntity<?>> post(ServerWebExchange request) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.post(wrapper, request);
    }

    @PostMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> post(ServerWebExchange request, @RequestBody(required=false) String body) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.post(wrapper, body, false);
    }

    @PostMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<?>> postStream(ServerWebExchange request, @RequestBody(required=false) String body) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.post(wrapper, body, true);
    }

    @GetMapping(path={"/**"})
    @ResponseBody
    public Mono<ResponseEntity<?>> get(ServerWebExchange request) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.get(wrapper);
    }

    @GetMapping(path={"/**"}, produces={"text/event-stream"})
    @ResponseBody
    public Mono<ResponseEntity<?>> getStream(ServerWebExchange request) {
        RequestProcessor.FunctionWrapper wrapper = this.wrapper(request);
        return this.processor.stream(wrapper);
    }

    private RequestProcessor.FunctionWrapper wrapper(ServerWebExchange request) {
        Function function = (Function)request.getAttribute(WebRequestConstants.FUNCTION);
        Consumer consumer = (Consumer)request.getAttribute(WebRequestConstants.CONSUMER);
        Supplier supplier = (Supplier)request.getAttribute(WebRequestConstants.SUPPLIER);
        RequestProcessor.FunctionWrapper wrapper = RequestProcessor.wrapper(function, consumer, supplier);
        wrapper.headers(request.getRequest().getHeaders());
        wrapper.params((MultiValueMap<String, String>)request.getRequest().getQueryParams());
        String argument = (String)request.getAttribute(WebRequestConstants.ARGUMENT);
        if (argument != null) {
            wrapper.argument(argument);
        }
        return wrapper;
    }
}

