/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.function.serverless.web.ProxyAsyncContext;
import org.springframework.cloud.function.serverless.web.ProxyFilterRegistration;
import org.springframework.cloud.function.serverless.web.ProxyHttpServletRequest;
import org.springframework.cloud.function.serverless.web.ProxyHttpServletResponse;
import org.springframework.cloud.function.serverless.web.ProxyServletContext;
import org.springframework.cloud.function.serverless.web.ServerlessWebApplication;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public final class ProxyMvc {
    public static String INIT_TIMEOUT = "contextInitTimeout";
    private static Log LOG = LogFactory.getLog(ProxyMvc.class);
    private volatile DispatcherServlet dispatcher;
    private volatile ConfigurableWebApplicationContext applicationContext;
    private ServletContext servletContext;
    private final CountDownLatch contextStartupLatch = new CountDownLatch(1);
    private final long initializatioinTimeout;

    public static ProxyMvc INSTANCE(Class<?> ... componentClasses) {
        ProxyMvc mvc = new ProxyMvc();
        mvc.initializeContextAsync(componentClasses);
        return mvc;
    }

    private ProxyMvc() {
        String timeoutValue = System.getenv(INIT_TIMEOUT);
        if (!StringUtils.hasText((String)timeoutValue)) {
            timeoutValue = System.getProperty(INIT_TIMEOUT);
        }
        this.initializatioinTimeout = StringUtils.hasText((String)timeoutValue) ? Long.valueOf(timeoutValue) : 20000L;
    }

    private void initializeContextAsync(Class<?> ... componentClasses) {
        new Thread(() -> {
            try {
                LOG.info((Object)"Starting application with the following configuration classes:");
                Stream.of(componentClasses).forEach(clazz -> LOG.info((Object)clazz.getSimpleName()));
                this.initContext(componentClasses);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.contextStartupLatch.countDown();
                LOG.info((Object)"Application is started successfully.");
            }
        }).start();
    }

    private void initContext(Class<?> ... componentClasses) {
        this.applicationContext = ServerlessWebApplication.run(componentClasses, new String[0]);
        ProxyServletContext servletContext = new ProxyServletContext();
        this.applicationContext.setServletContext((ServletContext)servletContext);
        this.applicationContext.refresh();
        if (this.applicationContext.containsBean("dispatcherServlet")) {
            this.dispatcher = (DispatcherServlet)this.applicationContext.getBean(DispatcherServlet.class);
        } else {
            this.dispatcher = new DispatcherServlet((WebApplicationContext)this.applicationContext);
            this.dispatcher.setDetectAllHandlerMappings(false);
            ((GenericApplicationContext)this.applicationContext).registerBean("dispatcherServlet", DispatcherServlet.class, () -> this.dispatcher, new BeanDefinitionCustomizer[0]);
        }
        ServletRegistration.Dynamic reg = servletContext.addServlet("dispatcherServlet", (Servlet)this.dispatcher);
        reg.setLoadOnStartup(1);
        this.servletContext = this.applicationContext.getServletContext();
        try {
            this.dispatcher.init((ServletConfig)new ProxyServletConfig(this.servletContext));
        }
        catch (Exception e) {
            throw new IllegalStateException("Faild to create Spring MVC DispatcherServlet proxy", e);
        }
    }

    public ConfigurableWebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void stop() {
        this.applicationContext.stop();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.contextStartupLatch.await(this.initializatioinTimeout, TimeUnit.MILLISECONDS);
            Assert.state((this.dispatcher != null ? 1 : 0) != 0, (String)("Failed to initialize Application within the specified time of " + this.initializatioinTimeout + " milliseconds. If you need to increase it, please set " + INIT_TIMEOUT + " environment variable"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.service(request, response, null);
    }

    public void service(HttpServletRequest request, HttpServletResponse response, CountDownLatch latch) throws Exception {
        ProxyFilterChain filterChain = new ProxyFilterChain(this.dispatcher);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        AsyncContext asyncContext = request.getAsyncContext();
        if (asyncContext != null) {
            filterChain = new ProxyFilterChain(this.dispatcher);
            if (asyncContext instanceof ProxyAsyncContext) {
                ProxyAsyncContext proxyAsyncContext = (ProxyAsyncContext)asyncContext;
                proxyAsyncContext.addDispatchHandler(() -> {
                    try {
                        new ProxyFilterChain(this.dispatcher).doFilter((ServletRequest)request, (ServletResponse)response);
                        asyncContext.complete();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
        }
        if (latch != null) {
            latch.countDown();
        }
    }

    private static class ProxyServletConfig
    implements ServletConfig {
        private final ServletContext servletContext;

        ProxyServletConfig(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public String getServletName() {
            return "dispatcherServlet";
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(new ArrayList());
        }

        public String getInitParameter(String name) {
            return null;
        }
    }

    private static class ProxyFilterChain
    implements FilterChain {
        @Nullable
        private ServletRequest request;
        @Nullable
        private ServletResponse response;
        private final List<Filter> filters;
        @Nullable
        private Iterator<Filter> iterator;

        ProxyFilterChain(DispatcherServlet servlet) {
            ArrayList filters = new ArrayList();
            servlet.getServletContext().getFilterRegistrations().values().forEach(fr -> filters.add(((ProxyFilterRegistration)fr).getFilter()));
            Assert.notNull(filters, (String)"filters cannot be null");
            Assert.noNullElements(filters, (String)"filters cannot contain null values");
            this.filters = ProxyFilterChain.initFilterList((Servlet)servlet, filters.toArray(new Filter[0]));
        }

        private static List<Filter> initFilterList(Servlet servlet, Filter ... filters) {
            Filter[] allFilters = (Filter[])ObjectUtils.addObjectToArray((Object[])filters, (Object)new ServletFilterProxy(servlet));
            return Arrays.asList(allFilters);
        }

        @Nullable
        public ServletRequest getRequest() {
            return this.request;
        }

        @Nullable
        public ServletResponse getResponse() {
            return this.response;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Assert.notNull((Object)request, (String)"Request must not be null");
            Assert.notNull((Object)response, (String)"Response must not be null");
            Assert.state((this.request == null ? 1 : 0) != 0, (String)"This FilterChain has already been called!");
            if (this.iterator == null) {
                this.iterator = this.filters.iterator();
            }
            if (this.iterator.hasNext()) {
                Filter nextFilter = this.iterator.next();
                nextFilter.doFilter(request, response, (FilterChain)this);
            }
            this.request = request;
            this.response = response;
        }

        private static final class ServletFilterProxy
        implements Filter {
            private final Servlet delegateServlet;

            private ServletFilterProxy(Servlet servlet) {
                Assert.notNull((Object)servlet, (String)"servlet cannot be null");
                this.delegateServlet = servlet;
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                try {
                    if (((HttpServletResponse)response).getStatus() != HttpStatus.OK.value() && request instanceof ProxyHttpServletRequest) {
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.status_code", (Object)((HttpServletResponse)response).getStatus());
                        this.setErrorMessageAttribute((ProxyHttpServletRequest)request, (ProxyHttpServletResponse)response, null);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)request).getRequestURI());
                        ((ProxyHttpServletRequest)request).setRequestURI("/error");
                        this.delegateServlet.service(request, response);
                    } else {
                        this.delegateServlet.service(request, response);
                    }
                }
                catch (Exception e) {
                    if (request instanceof ProxyHttpServletRequest) {
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.INTERNAL_SERVER_ERROR.value());
                        this.setErrorMessageAttribute((HttpServletRequest)request, (HttpServletResponse)response, e);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.exception_type", (Object)e);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)request).getRequestURI());
                        ((ProxyHttpServletRequest)request).setRequestURI("/error");
                    }
                    LOG.error((Object)("Failed processing the request to: " + ((HttpServletRequest)request).getRequestURI()), (Throwable)e);
                    this.delegateServlet.service(request, response);
                }
            }

            private void setErrorMessageAttribute(HttpServletRequest request, HttpServletResponse response, Exception exception) {
                ProxyHttpServletResponse proxyResponse;
                if (exception != null && StringUtils.hasText((String)exception.getMessage())) {
                    request.setAttribute("jakarta.servlet.error.message", (Object)exception.getMessage());
                } else if (response instanceof ProxyHttpServletResponse && StringUtils.hasText((String)(proxyResponse = (ProxyHttpServletResponse)response).getErrorMessage())) {
                    request.setAttribute("jakarta.servlet.error.message", (Object)proxyResponse.getErrorMessage());
                } else {
                    request.setAttribute("jakarta.servlet.error.message", (Object)HttpStatus.valueOf((int)response.getStatus()).getReasonPhrase());
                }
            }

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void destroy() {
            }

            public String toString() {
                return this.delegateServlet.toString();
            }
        }
    }
}

