/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.deployer.ContextRunner;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.util.ClassUtils;

public class ApplicationRunner {
    private static Log logger = LogFactory.getLog(ApplicationRunner.class);
    private final ClassLoader classLoader;
    private final String source;
    private final SpelParserConfiguration config;
    private final StandardTypeLocator typeLocator;
    private StandardEvaluationContext app;

    public ApplicationRunner(ClassLoader classLoader, String source) {
        this.classLoader = classLoader;
        this.source = source;
        this.config = new SpelParserConfiguration(null, this.classLoader);
        this.typeLocator = new StandardTypeLocator(this.classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String ... args) {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)this.classLoader);
            Class<?> cls = this.classLoader.loadClass(ContextRunner.class.getName());
            this.app = new StandardEvaluationContext(cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            this.app.setTypeLocator((TypeLocator)new StandardTypeLocator(this.classLoader));
            this.runContext(this.source, this.defaultProperties(UUID.randomUUID().toString()), args);
        }
        catch (Exception e) {
            logger.error((Object)"Cannot deploy", (Throwable)e);
        }
        finally {
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)contextLoader);
        }
        RuntimeException e = this.getError();
        if (e != null) {
            throw e;
        }
    }

    private Map<String, String> defaultProperties(String id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spring.liveBeansView.mbeanDomain", "function-deployer-" + id);
        map.put("spring.jmx.default-domain", "function-deployer-" + id);
        map.put("spring.jmx.enabled", "false");
        return map;
    }

    public Object getBean(String name) {
        if (this.app != null) {
            if (this.containsBeanByName(name)) {
                return this.getBeanByName(name);
            }
            try {
                return this.getBeanByType(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean containsBeanByName(String name) {
        Expression parsed = new SpelExpressionParser().parseExpression("context.containsBean(\"" + name + "\")");
        return (Boolean)parsed.getValue((EvaluationContext)this.app, Boolean.class);
    }

    private Object getBeanByName(String name) {
        Expression parsed = new SpelExpressionParser().parseExpression("context.getBean(\"" + name + "\")");
        return parsed.getValue((EvaluationContext)this.app);
    }

    private Object getBeanByType(String name) {
        Expression parsed = new SpelExpressionParser().parseExpression("context.getBean(T(" + name + "))");
        return parsed.getValue((EvaluationContext)this.app);
    }

    public boolean containsBean(String name) {
        if (this.app != null) {
            if (this.containsBeanByName(name)) {
                return true;
            }
            Expression parsed = new SpelExpressionParser().parseExpression("context.getBeansOfType(T(" + name + "))");
            try {
                Map beans = (Map)parsed.getValue((EvaluationContext)this.app);
                return !beans.isEmpty();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public Set<String> getBeanNames(String type) {
        if (this.app != null) {
            Expression parsed = new SpelExpressionParser().parseExpression("context.getBeansOfType(T(" + type + "))");
            try {
                Map beans = (Map)parsed.getValue((EvaluationContext)this.app);
                return beans.keySet();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptySet();
    }

    public Object evaluate(String expression, Object root, Object ... attrs) {
        Expression parsed = new SpelExpressionParser(this.config).parseExpression(expression);
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.setTypeLocator((TypeLocator)this.typeLocator);
        if (attrs.length % 2 != 0) {
            throw new IllegalArgumentException("Context attributes must be name, value pairs");
        }
        for (int i = 0; i < attrs.length / 2; ++i) {
            String name = (String)attrs[2 * i];
            Object value = attrs[2 * i + 1];
            context.setVariable(name, value);
        }
        return parsed.getValue((EvaluationContext)context);
    }

    public boolean isRunning() {
        if (this.app == null) {
            return false;
        }
        Expression parsed = new SpelExpressionParser().parseExpression("context.isRunning()");
        return (Boolean)parsed.getValue((EvaluationContext)this.app, Boolean.class);
    }

    @PreDestroy
    public void close() {
        this.closeContext();
    }

    private RuntimeException getError() {
        if (this.app == null) {
            return null;
        }
        Expression parsed = new SpelExpressionParser().parseExpression("error");
        Throwable e = (Throwable)parsed.getValue((EvaluationContext)this.app, Throwable.class);
        if (e == null) {
            return null;
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new IllegalStateException("Cannot launch", e);
    }

    private void runContext(String mainClass, Map<String, String> properties, String ... args) {
        Expression parsed = new SpelExpressionParser().parseExpression("run(#main,#properties,#args)");
        StandardEvaluationContext context = this.app;
        context.setVariable("main", (Object)mainClass);
        context.setVariable("properties", properties);
        context.setVariable("args", (Object)args);
        parsed.getValue((EvaluationContext)context);
    }

    private void closeContext() {
        if (this.app != null) {
            Expression parsed = new SpelExpressionParser().parseExpression("close()");
            parsed.getValue((EvaluationContext)this.app);
            this.app = null;
        }
    }
}

