/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.actuator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;

@Endpoint(id="functions")
public class FunctionsEndpoint {
    private final FunctionCatalog functionCatalog;

    public FunctionsEndpoint(FunctionCatalog functionCatalog) {
        this.functionCatalog = functionCatalog;
    }

    @ReadOperation
    public Map<String, Map<String, Object>> listAll() {
        TreeMap<String, Map<String, Object>> allFunctions = new TreeMap<String, Map<String, Object>>();
        Set<String> names = this.functionCatalog.getNames(null);
        for (String name : names) {
            SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.functionCatalog.lookup(name);
            LinkedHashMap<String, String> functionMap = new LinkedHashMap<String, String>();
            if (function.isFunction()) {
                functionMap.put("type", "FUNCTION");
                functionMap.put("input-type", this.toSimplePolyIn(function));
                functionMap.put("output-type", this.toSimplePolyOut(function));
            } else if (function.isConsumer()) {
                functionMap.put("type", "CONSUMER");
                functionMap.put("input-type", this.toSimplePolyIn(function));
            } else {
                functionMap.put("type", "SUPPLIER");
                functionMap.put("output-type", this.toSimplePolyOut(function));
            }
            allFunctions.put(name, functionMap);
        }
        return allFunctions;
    }

    private String toSimplePolyOut(SimpleFunctionRegistry.FunctionInvocationWrapper function) {
        return FunctionTypeUtils.getRawType(function.getItemType(function.getOutputType())).getSimpleName().toLowerCase();
    }

    private String toSimplePolyIn(SimpleFunctionRegistry.FunctionInvocationWrapper function) {
        return FunctionTypeUtils.getRawType(function.getItemType(function.getInputType())).getSimpleName().toLowerCase();
    }
}

