/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.context.config.KotlinLambdaToFunctionAutoConfiguration;
import org.springframework.cloud.function.core.FunctionInvocationHelper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BeanFactoryAwareFunctionRegistry
extends SimpleFunctionRegistry
implements ApplicationContextAware {
    private GenericApplicationContext applicationContext;

    public BeanFactoryAwareFunctionRegistry(ConversionService conversionService, CompositeMessageConverter messageConverter, JsonMapper jsonMapper, @Nullable FunctionProperties functionProperties, @Nullable FunctionInvocationHelper<Message<?>> functionInvocationHelper) {
        super(conversionService, messageConverter, jsonMapper, functionProperties, functionInvocationHelper);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    @Override
    public int size() {
        return this.applicationContext.getBeanNamesForType(Supplier.class).length + this.applicationContext.getBeanNamesForType(Function.class).length + this.applicationContext.getBeanNamesForType(Consumer.class).length + super.size();
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        Set<String> registeredNames = super.getNames(type);
        if (type == null) {
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(Function.class)));
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(Supplier.class)));
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(Consumer.class)));
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(BiFunction.class)));
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(BiConsumer.class)));
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(FunctionRegistration.class)));
        } else {
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(type)));
        }
        return registeredNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lookup(Class<?> type, String functionDefinition, String ... expectedOutputMimeTypes) {
        Object syncInstance;
        Collection functionalBeans;
        String string = functionDefinition = StringUtils.hasText((String)functionDefinition) ? functionDefinition : this.applicationContext.getEnvironment().getProperty("spring.cloud.function.definition", "");
        if (!this.applicationContext.containsBean(functionDefinition) || !KotlinDetector.isKotlinType(this.applicationContext.getBean(functionDefinition).getClass())) {
            functionDefinition = this.normalizeFunctionDefinition(functionDefinition);
        }
        if (!StringUtils.hasText((String)functionDefinition) && !CollectionUtils.isEmpty((Collection)(functionalBeans = (Collection)this.getNames(null).stream().filter(name -> !"functionRouter".equals(name)).filter(name -> !"defaultMessageRoutingHandler".equals(name)).collect(Collectors.toList()))) && functionalBeans.size() > 1) {
            this.logger.warn((Object)("Multiple functional beans were found " + functionalBeans + ", thus can't determine default function definition. Please use 'spring.cloud.function.definition' property to explicitly define it. "));
        }
        if (!this.isFunctionDefinitionEligible(functionDefinition)) {
            return null;
        }
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.doLookup(type, functionDefinition, expectedOutputMimeTypes);
        Object object = syncInstance = functionDefinition == null ? this : functionDefinition;
        synchronized (object) {
            if (function == null) {
                String[] functionNames;
                Set<String> functionRegistratioinNames = super.getNames(null);
                for (String functionName : functionNames = StringUtils.delimitedListToStringArray((String)functionDefinition.replaceAll(",", "|").trim(), (String)"|")) {
                    if (functionRegistratioinNames.contains(functionName) && this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Skipping function '" + functionName + "' since it is already present"));
                        continue;
                    }
                    Object functionCandidate = this.discoverFunctionInBeanFactory(functionName);
                    if (functionCandidate != null) {
                        Type functionType = null;
                        FunctionRegistration functionRegistration = null;
                        if (functionCandidate instanceof FunctionRegistration) {
                            functionRegistration = (FunctionRegistration)functionCandidate;
                        } else if (functionCandidate instanceof BiFunction || functionCandidate instanceof BiConsumer) {
                            functionRegistration = this.registerMessagingBiFunction(functionCandidate, functionName);
                        } else if (KotlinDetector.isKotlinType(functionCandidate.getClass())) {
                            KotlinLambdaToFunctionAutoConfiguration.KotlinFunctionWrapper wrapper = new KotlinLambdaToFunctionAutoConfiguration.KotlinFunctionWrapper(functionCandidate);
                            wrapper.setName(functionName);
                            wrapper.setBeanFactory((BeanFactory)this.applicationContext.getBeanFactory());
                            functionRegistration = wrapper.getFunctionRegistration();
                        } else if (this.isFunctionPojo(functionCandidate, functionName)) {
                            Method functionalMethod = FunctionTypeUtils.discoverFunctionalMethod(functionCandidate.getClass());
                            functionCandidate = this.proxyTarget(functionCandidate, functionalMethod);
                            functionType = FunctionTypeUtils.fromFunctionMethod(functionalMethod);
                        } else if (this.isSpecialFunctionRegistration(functionNames, functionName)) {
                            functionRegistration = (FunctionRegistration)this.applicationContext.getBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX, FunctionRegistration.class);
                        } else {
                            functionType = FunctionTypeUtils.discoverFunctionType(functionCandidate, functionName, this.applicationContext);
                        }
                        if (functionRegistration == null) {
                            functionRegistration = new FunctionRegistration<Object>(functionCandidate, functionName).type(functionType);
                        }
                        this.register(functionRegistration);
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Function '" + functionName + "' is not available in FunctionCatalog or BeanFactory"));
                }
                function = (SimpleFunctionRegistry.FunctionInvocationWrapper)super.doLookup(type, functionDefinition, expectedOutputMimeTypes);
            }
        }
        return (T)function;
    }

    private FunctionRegistration registerMessagingBiFunction(Object userFunction, String functionName) {
        Type biFunctionType = FunctionContextUtils.findType(this.applicationContext.getBeanFactory(), functionName);
        Object inputType1 = Object.class;
        Object inputType2 = Object.class;
        if (biFunctionType instanceof ParameterizedType) {
            inputType1 = ((ParameterizedType)biFunctionType).getActualTypeArguments()[0];
            inputType2 = ((ParameterizedType)biFunctionType).getActualTypeArguments()[1];
        }
        if (!FunctionTypeUtils.isTypeMap(inputType2)) {
            this.logger.debug((Object)"BiFunction's second argument must be assignable to Map, since BiFunction represents parsed Message with first argument being payload and second headers. Other signatures are not supported at the moment.");
        }
        ResolvableType messageType = ResolvableType.forClassWithGenerics(Message.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((Type)inputType1)});
        Type biFunctionWrapperType = ResolvableType.forClassWithGenerics(Function.class, (ResolvableType[])new ResolvableType[]{messageType, ResolvableType.forType((Type)inputType2)}).getType();
        Function<Object, Object> wrapperFunction = message -> {
            Object payload = ((Message)message).getPayload();
            if (payload.getClass().getName().equals("org.springframework.kafka.support.KafkaNull")) {
                payload = null;
            }
            if (userFunction instanceof BiConsumer) {
                ((BiConsumer)userFunction).accept(payload, ((Message)message).getHeaders());
                return null;
            }
            return ((BiFunction)userFunction).apply(payload, ((Message)message).getHeaders());
        };
        FunctionRegistration<Function<Object, Object>> functionRegistration = new FunctionRegistration<Function<Object, Object>>(wrapperFunction, functionName).type(biFunctionWrapperType);
        functionRegistration.setUserFunction(userFunction);
        return functionRegistration;
    }

    private Object discoverFunctionInBeanFactory(String functionName) {
        Object functionCandidate = null;
        if (this.applicationContext.containsBean(functionName)) {
            functionCandidate = this.applicationContext.getBean(functionName);
        } else {
            try {
                functionCandidate = BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this.applicationContext.getBeanFactory(), Object.class, (String)functionName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return functionCandidate;
    }

    @Override
    protected boolean containsFunction(String functionName) {
        return super.containsFunction(functionName) || this.applicationContext.containsBean(functionName);
    }

    private boolean isFunctionPojo(Object functionCandidate, String functionName) {
        return !functionCandidate.getClass().isSynthetic() && !(functionCandidate instanceof Supplier) && !(functionCandidate instanceof Function) && !(functionCandidate instanceof Consumer) && !this.applicationContext.containsBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX);
    }

    private boolean isSpecialFunctionRegistration(Object functionCandidate, String functionName) {
        return this.applicationContext.containsBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX);
    }

    private Object proxyTarget(Object targetFunction, final Method actualMethodToCall) {
        ProxyFactory pf = new ProxyFactory(targetFunction);
        pf.setProxyTargetClass(true);
        pf.setInterfaces(new Class[]{Function.class});
        pf.addAdvice((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                return actualMethodToCall.invoke(invocation.getThis(), invocation.getArguments());
            }
        });
        return pf.getProxy();
    }
}

