/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.Reader;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.json.JsonMapper;

public class JacksonMapper
extends JsonMapper {
    private static Log logger = LogFactory.getLog(JsonMapper.class);
    private final ObjectMapper mapper;

    public JacksonMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> T toObject(String json, Type type) {
        return this.fromJson(json, type);
    }

    @Override
    public <T> T fromJson(Object json, Type type) {
        Object convertedValue = null;
        JavaType constructType = TypeFactory.defaultInstance().constructType(type);
        try {
            if (json instanceof String) {
                convertedValue = this.mapper.readValue((String)json, constructType);
            } else if (json instanceof byte[]) {
                convertedValue = this.mapper.readValue((byte[])json, constructType);
            } else if (json instanceof Reader) {
                convertedValue = this.mapper.readValue((Reader)json, constructType);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to convert. Possible bug as the conversion probably shouldn't have been attampted here", (Throwable)e);
        }
        return (T)convertedValue;
    }

    @Override
    public byte[] toJson(Object value) {
        byte[] jsonBytes = super.toJson(value);
        if (jsonBytes == null) {
            try {
                jsonBytes = this.mapper.writeValueAsBytes(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jsonBytes;
    }

    @Override
    public String toString(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot convert to JSON", e);
        }
    }
}

