/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.util.ArrayList;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.springframework.cloud.function.compiler.java.CompiledClassDefinition;
import org.springframework.cloud.function.compiler.java.InMemoryJavaFileObject;

public class CompilationOutputCollector {
    private List<InMemoryJavaFileObject> outputFiles = new ArrayList<InMemoryJavaFileObject>();

    public List<CompiledClassDefinition> getCompiledClasses() {
        ArrayList<CompiledClassDefinition> compiledClassDefinitions = new ArrayList<CompiledClassDefinition>();
        for (InMemoryJavaFileObject outputFile : this.outputFiles) {
            if (outputFile.getKind() != JavaFileObject.Kind.CLASS) continue;
            CompiledClassDefinition compiledClassDefinition = new CompiledClassDefinition(outputFile.getName(), outputFile.getBytes());
            compiledClassDefinitions.add(compiledClassDefinition);
        }
        return compiledClassDefinitions;
    }

    public InMemoryJavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        InMemoryJavaFileObject jfo = InMemoryJavaFileObject.getJavaFileObject(location, className, kind, sibling);
        this.outputFiles.add(jfo);
        return jfo;
    }

    public InMemoryJavaFileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) {
        InMemoryJavaFileObject ojfo = InMemoryJavaFileObject.getFileObject(location, packageName, relativeName, sibling);
        this.outputFiles.add(ojfo);
        return ojfo;
    }
}

