/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public class ZipEntryJavaFileObject
implements JavaFileObject {
    private File containingFile;
    private ZipFile zf;
    private ZipEntry ze;
    private URI uri;

    public ZipEntryJavaFileObject(File containingFile, ZipFile zipFile, ZipEntry entry) {
        this.containingFile = containingFile;
        this.zf = zipFile;
        this.ze = entry;
    }

    @Override
    public URI toUri() {
        if (this.uri == null) {
            String uriString = null;
            try {
                uriString = "zip:" + this.containingFile.getAbsolutePath() + "!" + this.ze.getName();
                this.uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Unexpected URISyntaxException for string '" + uriString + "'", e);
            }
        }
        return this.uri;
    }

    @Override
    public String getName() {
        return this.ze.getName();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.zf.getInputStream(this.ze);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new IllegalStateException("only expected to be used for input");
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("openReader() not supported on class file: " + this.getName());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("getCharContent() not supported on class file: " + this.getName());
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new IllegalStateException("only expected to be used for input");
    }

    @Override
    public long getLastModified() {
        return this.ze.getTime();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.CLASS) {
            return false;
        }
        String name = this.getName();
        int lastSlash = name.lastIndexOf(47);
        return name.substring(lastSlash + 1).equals(simpleName + ".class");
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public int hashCode() {
        int hc = this.containingFile.getName().hashCode();
        hc = hc * 37 + this.ze.getName().hashCode();
        return hc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZipEntryJavaFileObject)) {
            return false;
        }
        ZipEntryJavaFileObject that = (ZipEntryJavaFileObject)obj;
        return this.containingFile.getName().equals(that.containingFile.getName()) && this.ze.getName().equals(that.ze.getName());
    }
}

