/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.openwhisk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.adapter.openwhisk.OpenWhiskActionRequest;
import org.springframework.cloud.function.adapter.openwhisk.OpenWhiskFunctionInitializer;
import org.springframework.cloud.function.adapter.openwhisk.OpenWhiskInitRequest;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
public class OpenWhiskActionHandler
extends OpenWhiskFunctionInitializer {
    private static final String NO_INPUT_PROVIDED = "No input provided";
    private static Log logger = LogFactory.getLog(OpenWhiskFunctionInitializer.class);
    @Autowired
    private ObjectMapper mapper;

    @PostMapping(value={"/init"})
    public void init(@RequestBody OpenWhiskInitRequest request) {
        this.initialize();
    }

    @PostMapping(value={"/run"}, consumes={"application/json"}, produces={"application/json"})
    public Object run(@RequestBody OpenWhiskActionRequest request) {
        Object input = this.convertEvent(request.getValue());
        Object result = NO_INPUT_PROVIDED;
        if (input != null) {
            Publisher<?> output = this.apply((Publisher<?>)this.extract(input));
            result = this.result(input, output);
        }
        return this.serializeBody(result);
    }

    private Object result(Object input, Publisher<?> output) {
        ArrayList result = new ArrayList();
        for (Object value : Flux.from(output).toIterable()) {
            result.add(value);
        }
        if (this.isSingleValue(input) && result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    private boolean isSingleValue(Object input) {
        return !(input instanceof Collection);
    }

    private Flux<?> extract(Object input) {
        if (input instanceof Collection) {
            return Flux.fromIterable((Iterable)((Iterable)input));
        }
        return Flux.just((Object)input);
    }

    protected Object convertEvent(Map<String, Object> value) {
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Action Request Value:" + value));
        }
        if (value != null) {
            Object payload = value.get("payload");
            return this.convertToFunctionParamType(payload);
        }
        return null;
    }

    private Object convertToFunctionParamType(Object payload) {
        try {
            return this.mapper.convertValue(payload, this.getInputType());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot convert event payload", e);
        }
    }

    private String serializeBody(Object body) {
        try {
            return "{\"result\":" + this.mapper.writeValueAsString(body) + "}";
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot convert output", e);
        }
    }
}

