/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.container.registry.ContainerImageRestTemplateFactory;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryConfiguration;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryProperties;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DockerConfigJsonSecretToRegistryConfigurationConverter
implements Converter<String, Map<String, ContainerRegistryConfiguration>> {
    private static final Logger logger = LoggerFactory.getLogger(DockerConfigJsonSecretToRegistryConfigurationConverter.class);
    public static final String BEARER_REALM_ATTRIBUTE = "Bearer realm";
    public static final String SERVICE_ATTRIBUTE = "service";
    public static final String HTTPS_INDEX_DOCKER_IO_V_1 = "https://index.docker.io/v1/";
    public static final String DOCKER_IO = "docker.io";
    public static final String REGISTRY_1_DOCKER_IO = "registry-1.docker.io";
    private final ContainerImageRestTemplateFactory containerImageRestTemplate;
    private final Map<String, Boolean> httpProxyPerHost;
    private final boolean replaceDefaultDockerRegistryServer;

    public DockerConfigJsonSecretToRegistryConfigurationConverter(ContainerRegistryProperties properties, ContainerImageRestTemplateFactory containerImageRestTemplate) {
        this.replaceDefaultDockerRegistryServer = properties.isReplaceDefaultDockerRegistryServer();
        this.httpProxyPerHost = properties.getRegistryConfigurations().entrySet().stream().collect(Collectors.toMap(e -> ((ContainerRegistryConfiguration)e.getValue()).getRegistryHost(), e -> ((ContainerRegistryConfiguration)e.getValue()).isUseHttpProxy()));
        this.containerImageRestTemplate = containerImageRestTemplate;
    }

    public Map<String, ContainerRegistryConfiguration> convert(String dockerconfigjson) {
        if (StringUtils.hasText((String)dockerconfigjson)) {
            try {
                Map authsMap = (Map)((Map)new ObjectMapper().readValue(dockerconfigjson, Map.class)).get("auths");
                HashMap<String, ContainerRegistryConfiguration> registryConfigurationMap = new HashMap<String, ContainerRegistryConfiguration>();
                for (Object registryUrl : authsMap.keySet()) {
                    ContainerRegistryConfiguration rc = new ContainerRegistryConfiguration();
                    rc.setRegistryHost(this.replaceDefaultDockerRegistryServerUrl(registryUrl.toString()));
                    Map registryMap = (Map)authsMap.get(registryUrl.toString());
                    rc.setUser((String)registryMap.get("username"));
                    rc.setSecret((String)registryMap.get("password"));
                    Optional<String> tokenAccessUrl = this.getDockerTokenServiceUri(rc.getRegistryHost(), true, this.httpProxyPerHost.getOrDefault(rc.getRegistryHost(), false));
                    if (tokenAccessUrl.isPresent()) {
                        rc.setAuthorizationType(ContainerRegistryConfiguration.AuthorizationType.dockeroauth2);
                        rc.getExtra().put("registryAuthUri", tokenAccessUrl.get());
                    } else if (StringUtils.isEmpty((Object)rc.getUser()) && StringUtils.isEmpty((Object)rc.getSecret())) {
                        rc.setAuthorizationType(ContainerRegistryConfiguration.AuthorizationType.anonymous);
                    } else {
                        rc.setAuthorizationType(ContainerRegistryConfiguration.AuthorizationType.basicauth);
                    }
                    logger.info("Registry Configuration: " + rc.toString());
                    registryConfigurationMap.put(rc.getRegistryHost(), rc);
                }
                return registryConfigurationMap;
            }
            catch (Exception e) {
                logger.error("Failed to parse the Secrets in dockerconfigjson");
            }
        }
        return Collections.emptyMap();
    }

    private String replaceDefaultDockerRegistryServerUrl(String dockerConfigJsonRegistryHost) {
        return this.replaceDefaultDockerRegistryServer && (DOCKER_IO.equals(dockerConfigJsonRegistryHost) || HTTPS_INDEX_DOCKER_IO_V_1.equals(dockerConfigJsonRegistryHost)) ? REGISTRY_1_DOCKER_IO : dockerConfigJsonRegistryHost;
    }

    public Optional<String> getDockerTokenServiceUri(String registryHost, boolean disableSSl, boolean useHttpProxy) {
        try {
            RestTemplate restTemplate = this.containerImageRestTemplate.getContainerRestTemplate(disableSSl, useHttpProxy);
            String host = registryHost;
            Integer port = null;
            if (registryHost.contains(":")) {
                int colon = registryHost.lastIndexOf(":");
                String portString = registryHost.substring(colon + 1);
                try {
                    int intPort = Integer.parseInt(portString);
                    if (Integer.toString(intPort).equals(portString) && intPort > 0 && intPort < Short.MAX_VALUE) {
                        port = intPort;
                        host = registryHost.substring(0, colon);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.newInstance().scheme("https").host(host);
            if (port != null) {
                uriComponentsBuilder.port(port.intValue());
            }
            uriComponentsBuilder.path("v2/");
            URI uri = uriComponentsBuilder.build().toUri();
            logger.info("getDockerTokenServiceUri:" + uri);
            restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)new HttpHeaders()), Map.class);
            return Optional.empty();
        }
        catch (HttpClientErrorException httpError) {
            if (httpError.getRawStatusCode() != 401) {
                return Optional.empty();
            }
            if (httpError.getResponseHeaders() == null || !httpError.getResponseHeaders().containsKey((Object)"WWW-Authenticate")) {
                return Optional.empty();
            }
            List wwwAuthenticate = httpError.getResponseHeaders().get((Object)"WWW-Authenticate");
            logger.info("Www-Authenticate: {} for container registry {}", (Object)wwwAuthenticate, (Object)registryHost);
            if (CollectionUtils.isEmpty((Collection)wwwAuthenticate)) {
                return Optional.empty();
            }
            Map<String, String> wwwAuthenticateAttributes = Stream.of(((String)wwwAuthenticate.get(0)).split(",")).map(s -> s.split("=")).collect(Collectors.toMap(b -> b[0], b -> b[1]));
            if (CollectionUtils.isEmpty(wwwAuthenticateAttributes) || !wwwAuthenticateAttributes.containsKey(BEARER_REALM_ATTRIBUTE) || !wwwAuthenticateAttributes.containsKey(SERVICE_ATTRIBUTE)) {
                logger.warn("Invalid Www-Authenticate: {} for container registry {}", (Object)wwwAuthenticate, (Object)registryHost);
                return Optional.empty();
            }
            String tokenServiceUri = String.format("%s?service=%s&scope=repository:{repository}:pull", wwwAuthenticateAttributes.get(BEARER_REALM_ATTRIBUTE), wwwAuthenticateAttributes.get(SERVICE_ATTRIBUTE));
            tokenServiceUri = tokenServiceUri.replaceAll("\"", "");
            logger.info("tokenServiceUri: " + tokenServiceUri);
            return Optional.of(tokenServiceUri);
        }
        catch (Exception e) {
            logger.error("Ignoring:" + e, (Throwable)e);
            return Optional.empty();
        }
    }
}

