/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.container.registry;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryException;
import org.springframework.cloud.dataflow.container.registry.ContainerRegistryProperties;
import org.springframework.cloud.dataflow.container.registry.authorization.DropAuthorizationHeaderRequestRedirectStrategy;
import org.springframework.http.MediaType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class ContainerImageRestTemplateFactory {
    private final RestTemplateBuilder restTemplateBuilder;
    private final ContainerRegistryProperties properties;
    private final ConcurrentHashMap<CacheKey, RestTemplate> restTemplateCache;

    public ContainerImageRestTemplateFactory(RestTemplateBuilder restTemplateBuilder, ContainerRegistryProperties properties) {
        this.restTemplateBuilder = restTemplateBuilder;
        this.properties = properties;
        this.restTemplateCache = new ConcurrentHashMap();
    }

    public RestTemplate getContainerRestTemplate(boolean skipSslVerification, boolean withHttpProxy) {
        try {
            CacheKey cacheKey = CacheKey.of(skipSslVerification, withHttpProxy);
            if (!this.restTemplateCache.containsKey(cacheKey)) {
                RestTemplate restTemplate = this.createContainerRestTemplate(skipSslVerification, withHttpProxy);
                this.restTemplateCache.putIfAbsent(cacheKey, restTemplate);
            }
            return this.restTemplateCache.get(cacheKey);
        }
        catch (Exception e) {
            throw new ContainerRegistryException("Failed to create Container Image RestTemplate for disableSsl:" + skipSslVerification + ", httpProxy:" + withHttpProxy, e);
        }
    }

    private RestTemplate createContainerRestTemplate(boolean skipSslVerification, boolean withHttpProxy) throws NoSuchAlgorithmException, KeyManagementException {
        if (!skipSslVerification) {
            return this.initRestTemplate(HttpClients.custom(), withHttpProxy);
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return this.initRestTemplate(HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE), withHttpProxy);
    }

    private RestTemplate initRestTemplate(HttpClientBuilder clientBuilder, boolean withHttpProxy) {
        clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
        if (withHttpProxy) {
            if (!this.properties.getHttpProxy().isEnabled()) {
                throw new ContainerRegistryException("Registry Configuration uses a HttpProxy but non is configured!");
            }
            HttpHost proxy = new HttpHost(this.properties.getHttpProxy().getHost(), this.properties.getHttpProxy().getPort());
            clientBuilder.setProxy(proxy);
        }
        HttpComponentsClientHttpRequestFactory customRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)clientBuilder.setRedirectStrategy((RedirectStrategy)new DropAuthorizationHeaderRequestRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().setNormalizeUri(false).build()).build());
        MappingJackson2HttpMessageConverter octetSupportJsonConverter = new MappingJackson2HttpMessageConverter();
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>(octetSupportJsonConverter.getSupportedMediaTypes());
        mediaTypeList.add(MediaType.APPLICATION_OCTET_STREAM);
        mediaTypeList.add(MediaType.TEXT_PLAIN);
        octetSupportJsonConverter.setSupportedMediaTypes(mediaTypeList);
        return this.restTemplateBuilder.additionalMessageConverters(new HttpMessageConverter[]{octetSupportJsonConverter}).requestFactory(() -> customRequestFactory).build();
    }

    private static class CacheKey {
        private final boolean disablesSslVerification;
        private final boolean useHttpProxy;

        public CacheKey(boolean disablesSslVerification, boolean useHttpProxy) {
            this.disablesSslVerification = disablesSslVerification;
            this.useHttpProxy = useHttpProxy;
        }

        static CacheKey of(boolean disablesSslVerification, boolean useHttpProxy) {
            return new CacheKey(disablesSslVerification, useHttpProxy);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.disablesSslVerification == cacheKey.disablesSslVerification && this.useHttpProxy == cacheKey.useHttpProxy;
        }

        public int hashCode() {
            return Objects.hash(this.disablesSslVerification, this.useHttpProxy);
        }
    }
}

