/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.dataflow.completion.RecoveryStrategy;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinitionService;
import org.springframework.util.Assert;

public abstract class StacktraceFingerprintingRecoveryStrategy<E extends Exception>
implements RecoveryStrategy<E> {
    private final Set<List<StackTraceElement>> fingerprints = new LinkedHashSet<List<StackTraceElement>>();
    private final Class<E> exceptionClass;
    protected StreamDefinitionService streamDefinitionService;

    public StacktraceFingerprintingRecoveryStrategy(Class<E> exceptionClass, StreamDefinitionService streamDefinitionService, String ... samples) {
        Assert.notNull(exceptionClass, (String)"exceptionClass should not be null");
        Assert.notNull((Object)streamDefinitionService, (String)"streamDefinitionService should not be null");
        Assert.notEmpty((Object[])samples, (String)"samples should not be null or empty");
        this.exceptionClass = exceptionClass;
        this.streamDefinitionService = streamDefinitionService;
        this.initFingerprints(samples);
    }

    private void initFingerprints(String ... samples) {
        for (String sample : samples) {
            try {
                this.streamDefinitionService.parse(new StreamDefinition("__dummy", sample));
            }
            catch (RuntimeException exception) {
                if (this.exceptionClass.isAssignableFrom(exception.getClass())) {
                    this.addFingerprintForException(exception);
                    continue;
                }
                throw exception;
            }
        }
    }

    private void addFingerprintForException(E exception) {
        boolean seenParserClass = false;
        ArrayList<StackTraceElement> fingerPrint = new ArrayList<StackTraceElement>();
        for (StackTraceElement frame : ((Throwable)exception).getStackTrace()) {
            if (frame.getClassName().equals(StreamDefinition.class.getName())) {
                seenParserClass = true;
            } else if (seenParserClass) break;
            fingerPrint.add(frame);
        }
        this.fingerprints.add(fingerPrint);
    }

    private boolean fingerprintMatches(E exception, List<StackTraceElement> fingerPrint) {
        int i = 0;
        StackTraceElement[] stackTrace = ((Throwable)exception).getStackTrace();
        for (StackTraceElement frame : fingerPrint) {
            if (frame.getClassName().contains("StreamParser") && (frame.getMethodName().equals("<init>") || frame.getMethodName().equals("parse"))) {
                return true;
            }
            if (stackTrace[i++].equals(frame)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldTrigger(String dslStart, Exception exception) {
        if (!this.exceptionClass.isAssignableFrom(exception.getClass())) {
            return false;
        }
        for (List<StackTraceElement> fingerPrint : this.fingerprints) {
            if (!this.fingerprintMatches(exception, fingerPrint)) continue;
            return true;
        }
        return false;
    }
}

