/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamDefinitionService;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

class EmptyStartYieldsSourceOrUnboundAppsRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<IllegalArgumentException> {
    private final AppRegistryService registry;

    public EmptyStartYieldsSourceOrUnboundAppsRecoveryStrategy(AppRegistryService registry, StreamDefinitionService streamDefinitionService) {
        super(IllegalArgumentException.class, streamDefinitionService, "");
        this.registry = registry;
    }

    @Override
    public void addProposals(String dsl, IllegalArgumentException exception, int detailLevel, List<CompletionProposal> proposals) {
        CompletionProposal.Factory completionFactory = CompletionProposal.expanding(dsl);
        for (AppRegistration app : this.registry.findAll()) {
            if (app.getType() != ApplicationType.source && app.getType() != ApplicationType.app) continue;
            proposals.add(completionFactory.withSeparateTokens(app.getName(), "Start with a source app or an unbounded streaming app"));
        }
    }
}

