/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ExpansionStrategy;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.AppRegistration;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinitionService;
import org.springframework.cloud.dataflow.core.StreamDefinitionServiceUtils;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;

public class ConfigurationPropertyValueHintExpansionStrategy
implements ExpansionStrategy {
    private final ProposalsCollectorSupportUtils collectorSupport;
    private final StreamDefinitionService streamDefinitionService;
    @Autowired
    private ValueHintProvider[] valueHintProviders = new ValueHintProvider[0];

    ConfigurationPropertyValueHintExpansionStrategy(AppRegistryService appRegistry, ApplicationConfigurationMetadataResolver metadataResolver, StreamDefinitionService streamDefinitionService) {
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
        this.streamDefinitionService = streamDefinitionService;
    }

    @Override
    public boolean addProposals(String text, StreamDefinition streamDefinition, int detailLevel, List<CompletionProposal> collector) {
        LinkedList streamAppDefinitions = this.streamDefinitionService.getAppDefinitions(streamDefinition);
        HashSet propertyNames = new HashSet(((StreamAppDefinition)StreamDefinitionServiceUtils.getDeploymentOrderIterator((LinkedList)streamAppDefinitions).next()).getProperties().keySet());
        propertyNames.removeAll(CompletionUtils.IMPLICIT_PARAMETER_NAMES);
        if (text.endsWith(" ") || propertyNames.isEmpty()) {
            return false;
        }
        String propertyName = this.recoverPropertyName(text);
        StreamAppDefinition lastApp = (StreamAppDefinition)StreamDefinitionServiceUtils.getDeploymentOrderIterator((LinkedList)streamAppDefinitions).next();
        String alreadyTyped = (String)lastApp.getProperties().get(propertyName);
        AppRegistration lastAppRegistration = this.collectorSupport.findAppRegistration(lastApp.getName(), CompletionUtils.determinePotentialTypes(lastApp, streamAppDefinitions.size() > 1));
        if (lastAppRegistration != null) {
            return this.collectorSupport.addAlreadyTypedValueHintsProposals(text, lastAppRegistration, collector, propertyName, this.valueHintProviders, alreadyTyped);
        }
        return false;
    }

    private String recoverPropertyName(String text) {
        try {
            this.streamDefinitionService.parse(new StreamDefinition("__dummy", text + " --"));
        }
        catch (CheckPointedParseException exception) {
            int end;
            List tokens = exception.getTokens();
            int tokenPointer = end = tokens.size() - 1 - 2;
            while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
                --tokenPointer;
            }
            StringBuilder builder = new StringBuilder();
            while (tokenPointer < end) {
                Token t = (Token)tokens.get(tokenPointer);
                if (t.isIdentifier()) {
                    builder.append(t.stringValue());
                } else {
                    builder.append(t.getKind().getTokenChars());
                }
                ++tokenPointer;
            }
            return builder.toString();
        }
        throw new AssertionError((Object)"Can't be reached");
    }
}

