/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;

public class BooleanValueHintProvider
implements ValueHintProvider {
    private static final List<ValueHint> BOOLEANS;

    @Override
    public List<ValueHint> generateValueHints(ConfigurationMetadataProperty property, ClassLoader classLoader) {
        return "java.lang.Boolean".equals(property.getType()) ? BOOLEANS : Collections.emptyList();
    }

    @Override
    public boolean isExclusive(ConfigurationMetadataProperty property) {
        return true;
    }

    static {
        ValueHint yes = new ValueHint();
        yes.setValue((Object)true);
        ValueHint no = new ValueHint();
        no.setValue((Object)false);
        BOOLEANS = Collections.unmodifiableList(Arrays.asList(yes, no));
    }
}

