/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ExpansionStrategy;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;

public class PipeIntoOtherAppsExpansionStrategy
implements ExpansionStrategy {
    private final AppRegistryCommon appRegistry;

    public PipeIntoOtherAppsExpansionStrategy(AppRegistryCommon appRegistry) {
        this.appRegistry = appRegistry;
    }

    @Override
    public boolean addProposals(String text, StreamDefinition parseResult, int detailLevel, List<CompletionProposal> collector) {
        boolean couldBeASink;
        if (text.isEmpty() || !text.endsWith(" ")) {
            return false;
        }
        StreamAppDefinition lastApp = (StreamAppDefinition)parseResult.getDeploymentOrderIterator().next();
        boolean bl = couldBeASink = this.appRegistry.find(lastApp.getName(), ApplicationType.sink) != null;
        if (couldBeASink) {
            boolean couldBeAProcessor;
            boolean bl2 = couldBeAProcessor = this.appRegistry.find(lastApp.getName(), ApplicationType.processor) != null;
            if (!couldBeAProcessor) {
                return false;
            }
        }
        CompletionProposal.Factory proposals = CompletionProposal.expanding(text);
        for (AppRegistration appRegistration : this.appRegistry.findAll()) {
            if (appRegistration.getType() != ApplicationType.processor && appRegistration.getType() != ApplicationType.sink) continue;
            String expansion = CompletionUtils.maybeQualifyWithLabel(appRegistration.getName(), parseResult);
            collector.add(proposals.withSeparateTokens("| " + expansion, "Continue stream definition with a " + appRegistration.getType()));
        }
        return false;
    }
}

