/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

public class CompletionProposal {
    private final String text;
    private final String explanation;

    public CompletionProposal(String text, String explanation) {
        this.text = text;
        this.explanation = explanation;
    }

    public static Factory expanding(String start) {
        return new Factory(start);
    }

    public String getText() {
        return this.text;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.text);
    }

    public static class Factory {
        private final String start;

        private Factory(String start) {
            this.start = start;
        }

        public CompletionProposal withSuffix(String suffix, String explanation) {
            return new CompletionProposal(this.start + suffix, explanation);
        }

        public CompletionProposal withSuffix(String suffix) {
            return this.withSuffix(suffix, null);
        }

        public CompletionProposal withSeparateTokens(String suffix, String explanation) {
            return new CompletionProposal(this.start.endsWith(" ") || this.start.isEmpty() ? this.start + suffix : this.start + " " + suffix, explanation);
        }

        public CompletionProposal withSeparateTokens(String suffix) {
            return this.withSeparateTokens(suffix, null);
        }
    }
}

