/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.database.mysql.MySQLConnection;
import org.flywaydb.database.mysql.MySQLDatabase;
import org.flywaydb.database.mysql.mariadb.MariaDBDatabaseType;

public class MySQL57Database
extends Database<MySQLConnection> {
    private final MySQLDatabase delegateDatabase;

    public MySQL57Database(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        this(configuration, jdbcConnectionFactory, statementInterceptor, new MySQLDatabase(configuration, jdbcConnectionFactory, statementInterceptor));
    }

    protected MySQL57Database(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor, MySQLDatabase delegateDatabase) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
        this.delegateDatabase = delegateDatabase;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return this.delegateDatabase.getRawCreateScript(table, baseline);
    }

    protected MySQLConnection doGetConnection(Connection connection) {
        return this.delegateDatabase.doGetConnection(connection);
    }

    protected MigrationVersion determineVersion() {
        return this.delegateDatabase.determineVersion();
    }

    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("5.1");
        if (this.databaseType instanceof MariaDBDatabaseType) {
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("10.4", Edition.ENTERPRISE);
            this.recommendFlywayUpgradeIfNecessary("10.6");
        } else {
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("5.7", Edition.ENTERPRISE);
            this.recommendFlywayUpgradeIfNecessary("8.0");
        }
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.delegateDatabase.close();
        }
    }

    protected String doGetCurrentUser() throws SQLException {
        return this.delegateDatabase.doGetCurrentUser();
    }

    public boolean supportsDdlTransactions() {
        return this.delegateDatabase.supportsDdlTransactions();
    }

    public boolean supportsChangingCurrentSchema() {
        return this.delegateDatabase.supportsChangingCurrentSchema();
    }

    public String getBooleanTrue() {
        return this.delegateDatabase.getBooleanTrue();
    }

    public String getBooleanFalse() {
        return this.delegateDatabase.getBooleanFalse();
    }

    public String getOpenQuote() {
        return this.delegateDatabase.getOpenQuote();
    }

    public String getCloseQuote() {
        return this.delegateDatabase.getCloseQuote();
    }

    public boolean catalogIsSchema() {
        return this.delegateDatabase.catalogIsSchema();
    }

    public boolean useSingleConnection() {
        return this.delegateDatabase.useSingleConnection();
    }
}

