/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GenericHttpBodyThen;
import org.springframework.cloud.contract.verifier.builder.JaxRsAcceptor;
import org.springframework.cloud.contract.verifier.builder.JaxRsResponseCookiesThen;
import org.springframework.cloud.contract.verifier.builder.JaxRsResponseHeadersThen;
import org.springframework.cloud.contract.verifier.builder.JaxRsStatusCodeThen;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class JaxRsThen
implements Then,
BodyMethodVisitor,
JaxRsAcceptor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final List<Then> thens = new LinkedList<Then>();

    JaxRsThen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, BodyParser bodyParser, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.thens.addAll(Arrays.asList(new JaxRsStatusCodeThen(this.blockBuilder, comparisonBuilder), new JaxRsResponseHeadersThen(this.blockBuilder, generatedClassMetaData, comparisonBuilder), new JaxRsResponseCookiesThen(this.blockBuilder, generatedClassMetaData, comparisonBuilder), new GenericHttpBodyThen(this.blockBuilder, generatedClassMetaData, bodyParser, comparisonBuilder)));
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata singleContractMetadata) {
        this.startBodyBlock(this.blockBuilder, "then:");
        this.bodyBlock(this.blockBuilder, this.thens, singleContractMetadata);
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return this.acceptType(this.generatedClassMetaData, singleContractMetadata);
    }
}

