/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.template;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.springframework.cloud.contract.spec.ContractTemplate;
import org.springframework.cloud.contract.spec.internal.CompositeContractTemplate;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.TestSideRequestTemplateModel;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsJsonPathHelper;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Template;

public class HandlebarsTemplateProcessor
implements TemplateProcessor,
ContractTemplate,
GroovyObject {
    private static final Pattern ESCAPED_LEGACY_JSON_PATH_PATTERN;
    private static final Pattern ESCAPED_JSON_PATH_PATTERN;
    private static final Pattern LEGACY_JSON_PATH_PATTERN;
    private static final Pattern JSON_PATH_PATTERN;
    private static final List<Pattern> PATTERNS;
    private static final String LEGACY_JSON_PATH_TEMPLATE_NAME = "jsonpath";
    private static final String JSON_PATH_TEMPLATE_NAME;
    private final ContractTemplate contractTemplate;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public HandlebarsTemplateProcessor() {
        MetaClass metaClass;
        CompositeContractTemplate compositeContractTemplate = new CompositeContractTemplate();
        this.contractTemplate = compositeContractTemplate;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public String transform(Request request, String testContents) {
        TestSideRequestTemplateModel templateModel = TestSideRequestTemplateModel.from(request);
        LinkedHashMap model = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{HandlebarsJsonPathHelper.REQUEST_MODEL_NAME, templateModel}), LinkedHashMap.class);
        Template bodyTemplate = this.uncheckedCompileTemplate(testContents);
        return this.templatedResponseBody(model, bodyTemplate);
    }

    @Override
    public boolean containsTemplateEntry(String line) {
        return line.contains(this.contractTemplate.openingTemplate()) && line.contains(this.contractTemplate.closingTemplate()) || line.contains(this.contractTemplate.escapedOpeningTemplate()) && line.contains(this.contractTemplate.escapedClosingTemplate());
    }

    @Override
    public boolean containsJsonPathTemplateEntry(String line) {
        return line.contains(StringGroovyMethods.plus((String)this.openingTemplate(), (CharSequence)LEGACY_JSON_PATH_TEMPLATE_NAME)) || line.contains(StringGroovyMethods.plus((String)this.openingTemplate(), (CharSequence)JSON_PATH_TEMPLATE_NAME)) || line.contains(StringGroovyMethods.plus((String)this.escapedOpeningTemplate(), (CharSequence)LEGACY_JSON_PATH_TEMPLATE_NAME)) || line.contains(StringGroovyMethods.plus((String)this.escapedOpeningTemplate(), (CharSequence)JSON_PATH_TEMPLATE_NAME));
    }

    @Override
    public String jsonPathFromTemplateEntry(String line) {
        if (!this.containsJsonPathTemplateEntry(line)) {
            return "";
        }
        Pattern pattern = null;
        Iterator<Pattern> iterator = PATTERNS.iterator();
        while (iterator.hasNext()) {
            pattern = (Pattern)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Pattern.class);
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return "";
    }

    private String templatedResponseBody(Map<String, TestSideRequestTemplateModel> model, Template bodyTemplate) {
        return this.uncheckedApplyTemplate(bodyTemplate, model);
    }

    private String uncheckedApplyTemplate(Template template, Object context) {
        String string = template.apply(context);
        try {
            return string;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private Template uncheckedCompileTemplate(String content) {
        Reference handlebars = new Reference((Object)new Handlebars());
        ((Handlebars)handlebars.get()).registerHelper(HandlebarsJsonPathHelper.NAME, (Helper)new HandlebarsJsonPathHelper());
        ((Handlebars)handlebars.get()).registerHelper(WireMockHelpers.jsonPath.name(), (Helper)new HandlebarsJsonPathHelper());
        public final class _uncheckedCompileTemplate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _uncheckedCompileTemplate_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)it, (Object)WireMockHelpers.jsonPath);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _uncheckedCompileTemplate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _uncheckedCompileTemplate_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference handlebars;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _uncheckedCompileTemplate_closure2(Object _outerInstance, Object _thisObject, Reference handlebars) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.handlebars = reference = handlebars;
            }

            public Object doCall(WireMockHelpers helper) {
                return ((Handlebars)this.handlebars.get()).registerHelper(helper.name(), (Helper)helper);
            }

            public Object call(WireMockHelpers helper) {
                return this.doCall(helper);
            }

            public Handlebars getHandlebars() {
                return (Handlebars)ScriptBytecodeAdapter.castToType((Object)this.handlebars.get(), Handlebars.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _uncheckedCompileTemplate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Collection)DefaultGroovyMethods.findAll((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)WireMockHelpers.values(), Object[].class)), (Closure)new _uncheckedCompileTemplate_closure1(this, this)), (Closure)new _uncheckedCompileTemplate_closure2(this, this, handlebars));
        Template template = ((Handlebars)handlebars.get()).compileInline(content);
        try {
            return template;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    public boolean startsWithTemplate(String text) {
        return this.contractTemplate.startsWithTemplate(text);
    }

    public boolean startsWithEscapedTemplate(String text) {
        return this.contractTemplate.startsWithEscapedTemplate(text);
    }

    public String openingTemplate() {
        return this.contractTemplate.openingTemplate();
    }

    public String closingTemplate() {
        return this.contractTemplate.closingTemplate();
    }

    public String escapedOpeningTemplate() {
        return this.contractTemplate.escapedOpeningTemplate();
    }

    public String escapedClosingTemplate() {
        return this.contractTemplate.escapedClosingTemplate();
    }

    public String url() {
        return this.contractTemplate.url();
    }

    public String query(String key) {
        return this.contractTemplate.query(key);
    }

    public String query(String key, int index) {
        return this.contractTemplate.query(key, index);
    }

    public String path() {
        return this.contractTemplate.path();
    }

    public String path(int index) {
        return this.contractTemplate.path(index);
    }

    public String header(String key) {
        return this.contractTemplate.header(key);
    }

    public String header(String key, int index) {
        return this.contractTemplate.header(key, index);
    }

    public String cookie(String key) {
        return this.contractTemplate.cookie(key);
    }

    public String body() {
        return this.contractTemplate.body();
    }

    public String body(String jsonPath) {
        return this.contractTemplate.body(jsonPath);
    }

    public String escapedUrl() {
        return this.contractTemplate.escapedUrl();
    }

    public String escapedQuery(String key) {
        return this.contractTemplate.escapedQuery(key);
    }

    public String escapedQuery(String key, int index) {
        return this.contractTemplate.escapedQuery(key, index);
    }

    public String escapedPath() {
        return this.contractTemplate.escapedPath();
    }

    public String escapedPath(int index) {
        return this.contractTemplate.escapedPath(index);
    }

    public String escapedHeader(String key) {
        return this.contractTemplate.escapedHeader(key);
    }

    public String escapedHeader(String key, int index) {
        return this.contractTemplate.escapedHeader(key, index);
    }

    public String escapedCookie(String key) {
        return this.contractTemplate.escapedCookie(key);
    }

    public String escapedBody() {
        return this.contractTemplate.escapedBody();
    }

    public String escapedBody(String jsonPath) {
        return this.contractTemplate.escapedBody(jsonPath);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != HandlebarsTemplateProcessor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        List list;
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        Pattern pattern4;
        ESCAPED_LEGACY_JSON_PATH_PATTERN = pattern4 = Pattern.compile("^.*\\{\\{\\{jsonpath this '(.*)'}}}.*$");
        ESCAPED_JSON_PATH_PATTERN = pattern3 = Pattern.compile("^.*\\{\\{\\{jsonPath request.body '(.*)'}}}.*$");
        LEGACY_JSON_PATH_PATTERN = pattern2 = Pattern.compile("^.*\\{\\{jsonpath this '(.*)'}}.*$");
        JSON_PATH_PATTERN = pattern = Pattern.compile("^.*\\{\\{jsonPath request.body '(.*)'}}.*$");
        PATTERNS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{ESCAPED_LEGACY_JSON_PATH_PATTERN, ESCAPED_JSON_PATH_PATTERN, LEGACY_JSON_PATH_PATTERN, JSON_PATH_PATTERN});
        JSON_PATH_TEMPLATE_NAME = string = WireMockHelpers.jsonPath.name();
    }

    @Generated
    public final ContractTemplate getContractTemplate() {
        return this.contractTemplate;
    }
}

