/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;

class LazyMessageVerifier
implements MessageVerifier {
    private MessageVerifier<?> messageVerifier;
    private final BeanFactory beanFactory;

    LazyMessageVerifier(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private MessageVerifier messageVerifier() {
        if (this.messageVerifier == null) {
            try {
                this.messageVerifier = (MessageVerifier)this.beanFactory.getBean(MessageVerifier.class);
            }
            catch (BeansException ex) {
                this.messageVerifier = new NoOpStubMessages();
            }
        }
        return this.messageVerifier;
    }

    public void send(Object message, String destination) {
        this.messageVerifier().send(message, destination);
    }

    public Object receive(String destination, long timeout, TimeUnit timeUnit) {
        return this.messageVerifier().receive(destination, timeout, timeUnit);
    }

    public Object receive(String destination) {
        return this.messageVerifier().receive(destination);
    }

    public void send(Object payload, Map headers, String destination) {
        this.messageVerifier().send(payload, headers, destination);
    }
}

