/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.eureka;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRunning;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerConfiguration;
import org.springframework.cloud.contract.stubrunner.spring.cloud.ConditionalOnStubbedDiscoveryDisabled;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubsRegistrar;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.ConditionalOnEurekaEnabled;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.EurekaStubsRegistrar;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(value={StubRunnerConfiguration.class, EurekaClientAutoConfiguration.class})
@ConditionalOnClass(value={CloudEurekaClient.class})
@ConditionalOnStubbedDiscoveryDisabled
@ConditionalOnEurekaEnabled
@ConditionalOnProperty(value={"stubrunner.cloud.eureka.enabled"}, matchIfMissing=true)
public class StubRunnerSpringCloudEurekaAutoConfiguration {

    @Profile(value={"cloud"})
    @Configuration
    protected static class CloudConfig {
        private static final int DEFAULT_PORT = 80;
        private static final Log log = LogFactory.getLog(CloudConfig.class);
        @Autowired
        Environment environment;

        protected CloudConfig() {
        }

        @Bean(initMethod="registerStubs")
        public StubsRegistrar stubsRegistrar(StubRunning stubRunning, ServiceRegistry<EurekaRegistration> serviceRegistry, ApplicationContext context, StubMapperProperties stubMapperProperties, InetUtils inetUtils, EurekaInstanceConfigBean eurekaInstanceConfigBean, EurekaClientConfigBean eurekaClientConfigBean) {
            return new EurekaStubsRegistrar(stubRunning, serviceRegistry, stubMapperProperties, inetUtils, eurekaInstanceConfigBean, eurekaClientConfigBean, context){

                @Override
                protected String hostName(Map.Entry<StubConfiguration, Integer> entry) {
                    String hostname = environment.getProperty("application.hostname") + "-" + entry.getValue() + "." + environment.getProperty("application.domain");
                    log.info((Object)("Registering stub [" + entry.getKey().getArtifactId() + "] with hostname [" + hostname + "]"));
                    return hostname;
                }

                @Override
                protected int port(Map.Entry<StubConfiguration, Integer> entry) {
                    return 80;
                }
            };
        }
    }

    @Profile(value={"!cloud"})
    @Configuration
    protected static class NonCloudConfig {
        protected NonCloudConfig() {
        }

        @Bean(initMethod="registerStubs")
        public StubsRegistrar stubsRegistrar(StubRunning stubRunning, ServiceRegistry<EurekaRegistration> serviceRegistry, ApplicationContext context, StubMapperProperties stubMapperProperties, InetUtils inetUtils, EurekaInstanceConfigBean eurekaInstanceConfigBean, EurekaClientConfigBean eurekaClientConfigBean) {
            return new EurekaStubsRegistrar(stubRunning, serviceRegistry, stubMapperProperties, inetUtils, eurekaInstanceConfigBean, eurekaClientConfigBean, context);
        }
    }
}

