/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.List;
import org.springframework.core.io.support.SpringFactoriesLoader;

public interface DslPropertyConverter {
    public static final DslPropertyConverter DEFAULT = new DslPropertyConverter(){};
    public static final DslPropertyConverter INSTANCE = DslPropertyConverter.instance();

    public static DslPropertyConverter instance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        final List converters = SpringFactoriesLoader.loadFactories(DslPropertyConverter.class, null);
        if (converters.isEmpty()) {
            return DEFAULT;
        }
        return new DslPropertyConverter(){

            @Override
            public Object testSide(Object object) {
                Object convertedObject = object;
                for (DslPropertyConverter converter : converters) {
                    convertedObject = converter.testSide(convertedObject);
                }
                return convertedObject;
            }

            @Override
            public Object stubSide(Object object) {
                Object convertedObject = object;
                for (DslPropertyConverter converter : converters) {
                    convertedObject = converter.stubSide(convertedObject);
                }
                return convertedObject;
            }
        };
    }

    default public Object testSide(Object object) {
        return object;
    }

    default public Object stubSide(Object object) {
        return object;
    }
}

