/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.spec.internal.PatternValueDslProperty;
import org.springframework.cloud.contract.spec.internal.RegexCreatingProperty;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.ResponseBodyMatchers;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;

public class OutputMessage
extends Common
implements RegexCreatingProperty<ServerDslProperty> {
    private static final Log log = LogFactory.getLog(OutputMessage.class);
    private DslProperty<String> sentTo;
    private Headers headers;
    private DslProperty body;
    private ExecutionProperty assertThat;
    private ResponseBodyMatchers bodyMatchers;
    private ServerPatternValueDslProperty property = new ServerPatternValueDslProperty();

    public OutputMessage() {
    }

    public OutputMessage(OutputMessage outputMessage) {
        this.sentTo = outputMessage.getSentTo();
        this.headers = outputMessage.getHeaders();
        this.body = outputMessage.getBody();
    }

    public void sentTo(String sentTo) {
        this.sentTo = new DslProperty<String>(sentTo);
    }

    public void sentTo(DslProperty sentTo) {
        this.sentTo = sentTo;
    }

    public void body(Object bodyAsValue) {
        this.body = new DslProperty<Object>(bodyAsValue);
    }

    public void body(DslProperty bodyAsValue) {
        this.body = bodyAsValue;
    }

    public void assertThat(String assertThat) {
        this.assertThat = new ExecutionProperty(assertThat);
    }

    @Deprecated
    public DslProperty value(ClientDslProperty clientDslProperty) {
        return this.value(new ServerDslProperty(clientDslProperty.getServerValue(), clientDslProperty.getClientValue()));
    }

    public DslProperty value(ServerDslProperty serverDslProperty) {
        Object concreteValue = serverDslProperty.getClientValue();
        Object dynamicValue = serverDslProperty.getServerValue();
        if (dynamicValue instanceof RegexProperty) {
            return ((RegexProperty)dynamicValue).concreteClientEscapedDynamicProducer();
        }
        return new DslProperty(concreteValue, dynamicValue);
    }

    @Deprecated
    public DslProperty $(ClientDslProperty client) {
        return this.value(client);
    }

    public DslProperty $(ServerDslProperty property) {
        return this.value(property);
    }

    public DslProperty $(Pattern pattern) {
        return this.value(new RegexProperty(pattern));
    }

    public DslProperty $(RegexProperty pattern) {
        return this.value(pattern);
    }

    public DslProperty value(RegexProperty pattern) {
        return this.value(this.producer(pattern));
    }

    public DslProperty $(OptionalProperty property) {
        return this.value(this.producer(property.optionalPatternValue()));
    }

    @Override
    public RegexProperty regexProperty(Object object) {
        return new RegexProperty(object).concreteClientDynamicProducer();
    }

    public ServerPatternValueDslProperty getProperty() {
        return this.property;
    }

    public void setProperty(ServerPatternValueDslProperty property) {
        this.property = property;
    }

    public DslProperty<String> getSentTo() {
        return this.sentTo;
    }

    public void setSentTo(DslProperty<String> sentTo) {
        this.sentTo = sentTo;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public DslProperty getBody() {
        return this.body;
    }

    public void setBody(DslProperty body) {
        this.body = body;
    }

    public ExecutionProperty getAssertThat() {
        return this.assertThat;
    }

    public void setAssertThat(ExecutionProperty assertThat) {
        this.assertThat = assertThat;
    }

    public ResponseBodyMatchers getBodyMatchers() {
        return this.bodyMatchers;
    }

    public void setBodyMatchers(ResponseBodyMatchers bodyMatchers) {
        this.bodyMatchers = bodyMatchers;
    }

    @Override
    public ServerDslProperty anyAlphaUnicode() {
        return (ServerDslProperty)this.property.anyAlphaUnicode();
    }

    @Override
    public ServerDslProperty anyAlphaNumeric() {
        return (ServerDslProperty)this.property.anyAlphaNumeric();
    }

    @Override
    public ServerDslProperty anyNumber() {
        return (ServerDslProperty)this.property.anyNumber();
    }

    @Override
    public ServerDslProperty anyInteger() {
        return (ServerDslProperty)this.property.anyInteger();
    }

    @Override
    public ServerDslProperty anyPositiveInt() {
        return (ServerDslProperty)this.property.anyPositiveInt();
    }

    @Override
    public ServerDslProperty anyDouble() {
        return (ServerDslProperty)this.property.anyDouble();
    }

    @Override
    public ServerDslProperty anyHex() {
        return (ServerDslProperty)this.property.anyHex();
    }

    @Override
    public ServerDslProperty aBoolean() {
        return (ServerDslProperty)this.property.aBoolean();
    }

    @Override
    public ServerDslProperty anyIpAddress() {
        return (ServerDslProperty)this.property.anyIpAddress();
    }

    @Override
    public ServerDslProperty anyHostname() {
        return (ServerDslProperty)this.property.anyHostname();
    }

    @Override
    public ServerDslProperty anyEmail() {
        return (ServerDslProperty)this.property.anyEmail();
    }

    @Override
    public ServerDslProperty anyUrl() {
        return (ServerDslProperty)this.property.anyUrl();
    }

    @Override
    public ServerDslProperty anyHttpsUrl() {
        return (ServerDslProperty)this.property.anyHttpsUrl();
    }

    @Override
    public ServerDslProperty anyUuid() {
        return (ServerDslProperty)this.property.anyUuid();
    }

    @Override
    public ServerDslProperty anyDate() {
        return (ServerDslProperty)this.property.anyDate();
    }

    @Override
    public ServerDslProperty anyDateTime() {
        return (ServerDslProperty)this.property.anyDateTime();
    }

    @Override
    public ServerDslProperty anyTime() {
        return (ServerDslProperty)this.property.anyTime();
    }

    @Override
    public ServerDslProperty anyIso8601WithOffset() {
        return (ServerDslProperty)this.property.anyIso8601WithOffset();
    }

    @Override
    public ServerDslProperty anyNonBlankString() {
        return (ServerDslProperty)this.property.anyNonBlankString();
    }

    @Override
    public ServerDslProperty anyNonEmptyString() {
        return (ServerDslProperty)this.property.anyNonEmptyString();
    }

    @Override
    public ServerDslProperty anyOf(String ... values) {
        return (ServerDslProperty)this.property.anyOf(values);
    }

    public void headers(Consumer<Headers> consumer) {
        this.headers = new Headers();
        consumer.accept(this.headers);
    }

    @Deprecated
    public void testMatchers(Consumer<ResponseBodyMatchers> consumer) {
        log.warn((Object)"testMatchers method is deprecated. Please use bodyMatchers instead");
        this.bodyMatchers(consumer);
    }

    public void bodyMatchers(Consumer<ResponseBodyMatchers> consumer) {
        this.bodyMatchers = new ResponseBodyMatchers();
        consumer.accept(this.bodyMatchers);
    }

    public void headers(@DelegatesTo(value=Headers.class) Closure consumer) {
        this.headers = new Headers();
        consumer.setDelegate((Object)this.headers);
        consumer.call();
    }

    @Deprecated
    public void testMatchers(@DelegatesTo(value=ResponseBodyMatchers.class) Closure consumer) {
        log.warn((Object)"testMatchers method is deprecated. Please use bodyMatchers instead");
        this.bodyMatchers(consumer);
    }

    public void bodyMatchers(@DelegatesTo(value=ResponseBodyMatchers.class) Closure consumer) {
        this.bodyMatchers = new ResponseBodyMatchers();
        consumer.setDelegate((Object)this.bodyMatchers);
        consumer.call();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutputMessage that = (OutputMessage)o;
        return Objects.equals(this.sentTo, that.sentTo) && Objects.equals(this.headers, that.headers) && Objects.equals(this.body, that.body) && Objects.equals(this.assertThat, that.assertThat) && Objects.equals(this.bodyMatchers, that.bodyMatchers);
    }

    public int hashCode() {
        return Objects.hash(this.sentTo, this.headers, this.body, this.assertThat, this.bodyMatchers);
    }

    public String toString() {
        return "OutputMessage{\n\tsentTo=" + this.sentTo + ", \n\theaders=" + this.headers + ", \n\tbody=" + this.body + ", \n\tassertThat=" + this.assertThat + ", \n\tbodyMatchers=" + this.bodyMatchers + "} \n\t" + super.toString();
    }

    private class ServerPatternValueDslProperty
    extends PatternValueDslProperty<ServerDslProperty> {
        private ServerPatternValueDslProperty() {
        }

        @Override
        protected ServerDslProperty createProperty(Pattern pattern, Object generatedValue) {
            return new ServerDslProperty(pattern, generatedValue);
        }
    }
}

