/* -*-             c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
// for license please see accompanying LICENSE.txt file (available also at http://www.xmlpull.org/)

package org.codehaus.plexus.util.xml.pull;

/**
 * This exception is thrown to signal XML Pull Parser related faults.
 *
 * @author <a href="http://www.extreme.indiana.edu/~aslom/">Aleksander Slominski</a>
 */
public class XmlPullParserException
    extends Exception
{
    /**
     * @deprecated use generic getCause() method
     */
    protected Throwable detail;

    protected int row = -1;

    protected int column = -1;

    /*
     * public XmlPullParserException() { }
     */

    public XmlPullParserException( String s )
    {
        super( s );
    }

    /*
     * public XmlPullParserException(String s, Throwable throwable) { super(s); this.detail = throwable; } public
     * XmlPullParserException(String s, int row, int column) { super(s); this.row = row; this.column = column; }
     */

    public XmlPullParserException( String msg, XmlPullParser parser, Throwable chain )
    {
        super( ( msg == null ? "" : msg + " " )
            + ( parser == null ? "" : "(position:" + parser.getPositionDescription() + ") " )
            + ( chain == null ? "" : "caused by: " + chain ), chain );

        if ( parser != null )
        {
            this.row = parser.getLineNumber();
            this.column = parser.getColumnNumber();
        }
        this.detail = chain;
    }

    /**
     * @deprecated Use the generic <code>getCause()</code> method
     * @return
     */
    public Throwable getDetail()
    {
        return getCause();
    }

    // public void setDetail(Throwable cause) { this.detail = cause; }
    public int getLineNumber()
    {
        return row;
    }

    public int getColumnNumber()
    {
        return column;
    }

    /*
     * public String getMessage() { if(detail == null) return super.getMessage(); else return super.getMessage() +
     * "; nested exception is: \n\t" + detail.getMessage(); }
     */

    // NOTE: code that prints this and detail is difficult in J2ME
    public void printStackTrace()
    {
        if ( getCause() == null )
        {
            super.printStackTrace();
        }
        else
        {
            synchronized ( System.err )
            {
                System.err.println( super.getMessage() + "; nested exception is:" );
                getCause().printStackTrace();
            }
        }
    }

}
