/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier.stubrunner;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.springframework.cloud.contract.stubrunner.AetherStubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Named
@Singleton
public class AetherStubDownloaderFactory {
    private static final Log log = LogFactory.getLog(AetherStubDownloaderFactory.class);
    private final MavenProject project;
    private final RepositorySystem repoSystem;

    @Inject
    public AetherStubDownloaderFactory(RepositorySystem repoSystem, MavenProject project) {
        this.repoSystem = repoSystem;
        this.project = project;
    }

    public StubDownloaderBuilder build(final RepositorySystemSession repoSession) {
        return new StubDownloaderBuilder(){

            public StubDownloader build(StubRunnerOptions stubRunnerOptions) {
                log.info((Object)"Will download contracts using current build's Maven repository setup");
                return new AetherStubDownloader(AetherStubDownloaderFactory.this.repoSystem, AetherStubDownloaderFactory.this.project.getRemoteProjectRepositories(), repoSession);
            }

            public Resource resolve(String location, ResourceLoader resourceLoader) {
                return null;
            }
        };
    }
}

