/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.springframework.cloud.contract.stubrunner.ContractDownloader;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.util.StringUtils;

class GradleContractsDownloader
implements GroovyObject {
    private static final String LATEST_VERSION;
    private final Project project;
    private final Logger log;
    protected static final Map<StubConfiguration, File> downloadedContract;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GradleContractsDownloader(Project project, Logger log) {
        Logger logger;
        Project project2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = project2 = project;
        this.log = logger = log;
    }

    public File downloadAndUnpackContractsIfRequired(ContractVerifierExtension extension, ContractVerifierConfigProperties config) {
        File defaultContractsDir = extension.getContractsDslDir();
        this.log.info("Project has group id [{}], artifact id [{}]", this.project.getGroup(), (Object)this.project.getName());
        if (this.shouldDownloadContracts(extension)) {
            this.log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.project.getName()}, new String[]{"For project [", "] Download dependency is provided - will download contract jars"})));
            this.log.info("Contract dependency [{}]", (Object)extension.getContractDependency());
            StubConfiguration configuration = this.stubConfiguration(extension.getContractDependency());
            this.log.info("Got the following contract dependency to download [{}]", (Object)configuration);
            this.log.info("The contract dependency is a changing one [{}] and cache download switch is set to [{}]", (Object)configuration.isVersionChanging(), (Object)extension.getContractRepository().getCacheDownloadedContracts());
            if (!configuration.isVersionChanging() && extension.getContractRepository().getCacheDownloadedContracts()) {
                this.log.info("Resolved a non changing version - will try to return the folder from a cache");
                File cachedFolder = (File)ScriptBytecodeAdapter.castToType((Object)downloadedContract.get(configuration), File.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)cachedFolder)) {
                    this.log.info("For project [{}] returning the cached location of the contracts", (Object)this.project.getName());
                    this.contractDownloader(extension, configuration).updatePropertiesWithInclusion(cachedFolder, config);
                    return cachedFolder;
                }
            }
            File downloadedContracts = this.contractDownloader(extension, configuration).unpackedDownloadedContracts(config);
            downloadedContract.put(configuration, downloadedContracts);
            return downloadedContracts;
        }
        this.log.info("For project [{}] will use contracts provided in the folder [{}]", (Object)this.project.getName(), (Object)defaultContractsDir);
        return defaultContractsDir;
    }

    private boolean shouldDownloadContracts(ContractVerifierExtension extension) {
        return StringUtils.hasText((String)extension.getContractDependency().getArtifactId()) || StringUtils.hasText((String)extension.getContractDependency().getStringNotation()) || StringUtils.hasText((String)extension.getContractRepository().getRepositoryUrl());
    }

    protected ContractDownloader contractDownloader(ContractVerifierExtension extension, StubConfiguration configuration) {
        return new ContractDownloader(this.stubDownloader(extension), configuration, extension.getContractsPath(), (String)ScriptBytecodeAdapter.asType((Object)this.project.getGroup(), String.class), this.project.getName(), (String)ScriptBytecodeAdapter.asType((Object)this.project.getVersion(), String.class));
    }

    protected StubDownloader stubDownloader(ContractVerifierExtension extension) {
        StubDownloaderBuilderProvider provider = new StubDownloaderBuilderProvider();
        return provider.get(this.options(extension), new StubDownloaderBuilder[0]);
    }

    protected StubRunnerOptions options(ContractVerifierExtension extension) {
        StubRunnerOptionsBuilder options = new StubRunnerOptionsBuilder().withOptions(StubRunnerOptions.fromSystemProps()).withStubRepositoryRoot(extension.getContractRepository().getRepositoryUrl()).withStubsMode(extension.getContractsMode()).withUsername(extension.getContractRepository().getUsername()).withPassword(extension.getContractRepository().getPassword()).withDeleteStubsAfterTest(extension.getDeleteStubsAfterTest()).withProperties(extension.getContractsProperties());
        if (DefaultTypeTransformation.booleanUnbox((Object)extension.getContractRepository().getProxyPort())) {
            StubRunnerOptionsBuilder stubRunnerOptionsBuilder;
            options = stubRunnerOptionsBuilder = options.withProxy(extension.getContractRepository().getProxyHost(), extension.getContractRepository().getProxyPort().intValue());
        }
        return options.build();
    }

    StubConfiguration stubConfiguration(ContractVerifierExtension.Dependency contractDependency) {
        String groupId = contractDependency.getGroupId();
        String artifactId = contractDependency.getArtifactId();
        String version = StringUtils.hasText((String)contractDependency.getVersion()) ? contractDependency.getVersion() : LATEST_VERSION;
        String classifier = contractDependency.getClassifier();
        String stringNotation = contractDependency.getStringNotation();
        if (StringUtils.hasText((String)stringNotation)) {
            StubConfiguration stubConfiguration = new StubConfiguration(stringNotation);
            return new StubConfiguration(stubConfiguration.getGroupId(), stubConfiguration.getArtifactId(), stubConfiguration.getVersion(), stubConfiguration.getClassifier());
        }
        return new StubConfiguration(groupId, artifactId, version, classifier);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GradleContractsDownloader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        LATEST_VERSION = string = "+";
        ConcurrentHashMap<StubConfiguration, File> concurrentHashMap = new ConcurrentHashMap<StubConfiguration, File>();
        downloadedContract = concurrentHashMap;
    }
}

