/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LdapAuthorityMapper
implements GrantedAuthoritiesMapper {
    private final Map<CoreSecurityRoles, SimpleGrantedAuthority> roleMappings = new HashMap<CoreSecurityRoles, SimpleGrantedAuthority>(0);
    private String rolePrefix = "ROLE_";

    public LdapAuthorityMapper(Map<String, String> roleMappings) {
        Assert.notEmpty(roleMappings, (String)"The provided roleMappings must neither be null nor empty.");
        ArrayList<CoreSecurityRoles> unmappedRoles = new ArrayList<CoreSecurityRoles>(0);
        for (CoreSecurityRoles coreRole : CoreSecurityRoles.values()) {
            String coreSecurityRoleName = this.rolePrefix.length() > 0 && !coreRole.getKey().startsWith(this.rolePrefix) ? this.rolePrefix + coreRole.getKey() : coreRole.getKey();
            String ldapRole = roleMappings.get(coreSecurityRoleName);
            if (ldapRole == null) {
                unmappedRoles.add(coreRole);
                continue;
            }
            SimpleGrantedAuthority ldapRoleAuthority = new SimpleGrantedAuthority(this.rolePrefix + ldapRole);
            this.roleMappings.put(coreRole, ldapRoleAuthority);
        }
        if (!unmappedRoles.isEmpty()) {
            throw new IllegalArgumentException(String.format("The following %s %s not mapped: %s.", unmappedRoles.size(), unmappedRoles.size() > 1 ? "roles are" : "role is", StringUtils.collectionToCommaDelimitedString(unmappedRoles)));
        }
    }

    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        Set authoritiesToReturn = authorities.stream().map(authority -> this.mapAuthority((GrantedAuthority)authority)).flatMap(Collection::stream).filter(authority -> authority != null).collect(Collectors.toSet());
        return authoritiesToReturn;
    }

    private Set<SimpleGrantedAuthority> mapAuthority(GrantedAuthority ldapRoleAuthority) {
        Set<SimpleGrantedAuthority> authorities = this.roleMappings.entrySet().stream().filter(roleMapEntry -> ldapRoleAuthority.getAuthority().equalsIgnoreCase(((SimpleGrantedAuthority)roleMapEntry.getValue()).getAuthority())).map(roleMapEntry -> new SimpleGrantedAuthority(this.rolePrefix + ((CoreSecurityRoles)((Object)((Object)roleMapEntry.getKey()))).getKey())).collect(Collectors.toSet());
        return authorities;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix cannot be null");
        this.rolePrefix = rolePrefix;
    }
}

