/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.StringUtils;

public class ExternalOauth2ResourceAuthoritiesExtractor
implements AuthoritiesExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ExternalOauth2ResourceAuthoritiesExtractor.class);
    public static final GrantedAuthority CREATE = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.CREATE.getKey());
    public static final GrantedAuthority MANAGE = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.MANAGE.getKey());
    public static final GrantedAuthority VIEW = new SimpleGrantedAuthority("ROLE_" + CoreSecurityRoles.VIEW.getKey());
    private final OAuth2RestTemplate restTemplate;
    private final URI roleProviderUri;

    public ExternalOauth2ResourceAuthoritiesExtractor(OAuth2RestTemplate restTemplate, URI roleProviderUri) {
        this.restTemplate = restTemplate;
        this.roleProviderUri = roleProviderUri;
    }

    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        logger.debug("Getting permissions from {}", (Object)this.roleProviderUri);
        OAuth2AccessToken token = this.restTemplate.getAccessToken();
        RequestEntity request = RequestEntity.get((URI)this.roleProviderUri).header("Authorization", new String[]{"bearer " + token.getValue()}).build();
        ResponseEntity entity = this.restTemplate.exchange(request, String[].class);
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        block5: for (String permission : (String[])entity.getBody()) {
            if (StringUtils.isEmpty((Object)permission)) {
                logger.warn("Received an empty permission from {}", (Object)this.roleProviderUri);
                continue;
            }
            CoreSecurityRoles securityRole = CoreSecurityRoles.fromKey(permission.toUpperCase());
            if (securityRole == null) {
                logger.warn("Invalid role {} provided by {}", (Object)permission, (Object)this.roleProviderUri);
                continue;
            }
            switch (securityRole) {
                case CREATE: {
                    authorities.add(CREATE);
                    continue block5;
                }
                case MANAGE: {
                    authorities.add(MANAGE);
                    continue block5;
                }
                case VIEW: {
                    authorities.add(VIEW);
                }
            }
        }
        logger.info("Roles {} add for user {}", authorities, map);
        return authorities;
    }
}

