/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.cloud.common.security.ManualOAuthAuthenticationDetails;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.client.ResourceAccessException;

public class ManualOAuthAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(ManualOAuthAuthenticationProvider.class);
    @Autowired
    private OAuth2ClientProperties oAuth2ClientProperties;
    @Value(value="${security.oauth2.client.access-token-uri}")
    private String accessTokenUri;
    @Autowired
    private UserInfoTokenServices userInfoTokenServices;

    public AccessTokenProvider userAccessTokenProvider() {
        ResourceOwnerPasswordAccessTokenProvider accessTokenProvider = new ResourceOwnerPasswordAccessTokenProvider();
        return accessTokenProvider;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2AccessToken accessToken;
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        ResourceOwnerPasswordResourceDetails resource = new ResourceOwnerPasswordResourceDetails();
        resource.setUsername(username);
        resource.setPassword(password);
        resource.setAccessTokenUri(this.accessTokenUri);
        resource.setClientId(this.oAuth2ClientProperties.getClientId());
        resource.setClientSecret(this.oAuth2ClientProperties.getClientSecret());
        resource.setGrantType("password");
        OAuth2RestTemplate template = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resource, (OAuth2ClientContext)new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest()));
        template.setAccessTokenProvider(this.userAccessTokenProvider());
        try {
            logger.warn("Authenticating user '{}' using accessTokenUri '{}'.", (Object)username, (Object)this.accessTokenUri);
            accessToken = template.getAccessToken();
        }
        catch (OAuth2AccessDeniedException e) {
            if (e.getCause() instanceof ResourceAccessException) {
                String errorMessage = String.format("While authenticating user '%s': Unable to access accessTokenUri '%s'.", username, this.accessTokenUri);
                logger.error(errorMessage + " Error message: {}.", (Object)e.getCause().getMessage());
                throw new AuthenticationServiceException(errorMessage, (Throwable)e);
            }
            throw new BadCredentialsException(String.format("Access denied for user '%s'.", username), (Throwable)e);
        }
        catch (OAuth2Exception e) {
            throw new AuthenticationServiceException(String.format("Unable to perform OAuth authentication for user '%s'.", username), (Throwable)e);
        }
        ManualOAuthAuthenticationDetails details = new ManualOAuthAuthenticationDetails(accessToken);
        OAuth2Authentication auth2Authentication = this.userInfoTokenServices.loadAuthentication(accessToken.getValue());
        auth2Authentication.setDetails((Object)details);
        return auth2Authentication;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

