/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.retry;

public enum InstanceStatus {
    CREATING(true, false),
    AVAILABLE(true, true),
    REBOOTING(true, false),
    MODIFYING(true, true),
    DELETING(false, false),
    UNKNOWN(false, false);

    private final boolean retryable;
    private final boolean available;

    private InstanceStatus(boolean retryable, boolean available) {
        this.retryable = retryable;
        this.available = available;
    }

    static InstanceStatus fromDatabaseStatus(String databaseStatus) {
        for (InstanceStatus instanceStatus : InstanceStatus.values()) {
            if (!instanceStatus.name().equalsIgnoreCase(databaseStatus)) continue;
            return instanceStatus;
        }
        return UNKNOWN;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    public boolean isAvailable() {
        return this.available;
    }
}

