/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.EncoderBase;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.logging.StackTracePrinter;
import org.springframework.boot.logging.logback.ElasticCommonSchemaStructuredLogFormatter;
import org.springframework.boot.logging.logback.GraylogExtendedLogFormatStructuredLogFormatter;
import org.springframework.boot.logging.logback.LogstashStructuredLogFormatter;
import org.springframework.boot.logging.structured.CommonStructuredLogFormat;
import org.springframework.boot.logging.structured.ContextPairs;
import org.springframework.boot.logging.structured.StructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLogFormatterFactory;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.boot.util.Instantiator;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class StructuredLogEncoder
extends EncoderBase<ILoggingEvent> {
    private final ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();
    private @Nullable String format;
    private @Nullable StructuredLogFormatter<ILoggingEvent> formatter;
    private @Nullable Charset charset = StandardCharsets.UTF_8;

    public void setFormat(String format) {
        this.format = format;
    }

    public void setCharset(@Nullable Charset charset) {
        this.charset = charset;
    }

    public void start() {
        Assert.state((this.format != null ? 1 : 0) != 0, (String)"Format has not been set");
        this.formatter = this.createFormatter(this.format);
        super.start();
        this.throwableProxyConverter.start();
    }

    private StructuredLogFormatter<ILoggingEvent> createFormatter(String format) {
        Environment environment = (Environment)this.getContext().getObject(Environment.class.getName());
        Assert.state((environment != null ? 1 : 0) != 0, (String)"Unable to find Spring Environment in logger context");
        return new StructuredLogFormatterFactory<ILoggingEvent>(ILoggingEvent.class, environment, this::addAvailableParameters, this::addCommonFormatters).get(format);
    }

    private void addAvailableParameters(Instantiator.AvailableParameters availableParameters) {
        availableParameters.add(ThrowableProxyConverter.class, this.throwableProxyConverter);
    }

    private void addCommonFormatters(StructuredLogFormatterFactory.CommonFormatters<ILoggingEvent> commonFormatters) {
        commonFormatters.add(CommonStructuredLogFormat.ELASTIC_COMMON_SCHEMA, this::createEcsFormatter);
        commonFormatters.add(CommonStructuredLogFormat.GRAYLOG_EXTENDED_LOG_FORMAT, this::createGraylogFormatter);
        commonFormatters.add(CommonStructuredLogFormat.LOGSTASH, this::createLogstashFormatter);
    }

    private StructuredLogFormatter<ILoggingEvent> createEcsFormatter(Instantiator<?> instantiator) {
        Environment environment = instantiator.getArg(Environment.class);
        StackTracePrinter stackTracePrinter = instantiator.getArg(StackTracePrinter.class);
        ContextPairs contextPairs = instantiator.getArg(ContextPairs.class);
        ThrowableProxyConverter throwableProxyConverter = instantiator.getArg(ThrowableProxyConverter.class);
        StructuredLoggingJsonMembersCustomizer.Builder jsonMembersCustomizerBuilder = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.Builder.class);
        Assert.state((environment != null ? 1 : 0) != 0, (String)"'environment' must not be null");
        Assert.state((contextPairs != null ? 1 : 0) != 0, (String)"'contextPairs' must not be null");
        Assert.state((throwableProxyConverter != null ? 1 : 0) != 0, (String)"'throwableProxyConverter' must not be null");
        Assert.state((jsonMembersCustomizerBuilder != null ? 1 : 0) != 0, (String)"'jsonMembersCustomizerBuilder' must not be null");
        return new ElasticCommonSchemaStructuredLogFormatter(environment, stackTracePrinter, contextPairs, throwableProxyConverter, jsonMembersCustomizerBuilder);
    }

    private StructuredLogFormatter<ILoggingEvent> createGraylogFormatter(Instantiator<?> instantiator) {
        Environment environment = instantiator.getArg(Environment.class);
        StackTracePrinter stackTracePrinter = instantiator.getArg(StackTracePrinter.class);
        ContextPairs contextPairs = instantiator.getArg(ContextPairs.class);
        ThrowableProxyConverter throwableProxyConverter = instantiator.getArg(ThrowableProxyConverter.class);
        StructuredLoggingJsonMembersCustomizer jsonMembersCustomizer = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.class);
        Assert.state((environment != null ? 1 : 0) != 0, (String)"'environment' must not be null");
        Assert.state((contextPairs != null ? 1 : 0) != 0, (String)"'contextPairs' must not be null");
        Assert.state((throwableProxyConverter != null ? 1 : 0) != 0, (String)"'throwableProxyConverter' must not be null");
        return new GraylogExtendedLogFormatStructuredLogFormatter(environment, stackTracePrinter, contextPairs, throwableProxyConverter, jsonMembersCustomizer);
    }

    private StructuredLogFormatter<ILoggingEvent> createLogstashFormatter(Instantiator<?> instantiator) {
        StackTracePrinter stackTracePrinter = instantiator.getArg(StackTracePrinter.class);
        ContextPairs contextPairs = instantiator.getArg(ContextPairs.class);
        ThrowableProxyConverter throwableProxyConverter = instantiator.getArg(ThrowableProxyConverter.class);
        StructuredLoggingJsonMembersCustomizer jsonMembersCustomizer = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.class);
        Assert.state((contextPairs != null ? 1 : 0) != 0, (String)"'contextPairs' must not be null");
        Assert.state((throwableProxyConverter != null ? 1 : 0) != 0, (String)"'throwableProxyConverter' must not be null");
        return new LogstashStructuredLogFormatter(stackTracePrinter, contextPairs, throwableProxyConverter, jsonMembersCustomizer);
    }

    public void stop() {
        this.throwableProxyConverter.stop();
        super.stop();
    }

    public byte @Nullable [] headerBytes() {
        return null;
    }

    public byte[] encode(ILoggingEvent event) {
        Assert.state((this.formatter != null ? 1 : 0) != 0, (String)"formatter must not be null. Make sure to call start() before this method");
        return this.formatter.formatAsBytes(event, this.charset != null ? this.charset : StandardCharsets.UTF_8);
    }

    public byte @Nullable [] footerBytes() {
        return null;
    }
}

