/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.boot.ssl.pem.PemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.util.function.ThrowingSupplier;

final class LoadedPemSslStore
implements PemSslStore {
    private final PemSslStoreDetails details;
    private final ResourceLoader resourceLoader;
    private final Supplier<CertificatesHolder> certificatesSupplier;
    private final Supplier<PrivateKeyHolder> privateKeySupplier;

    LoadedPemSslStore(PemSslStoreDetails details, ResourceLoader resourceLoader) {
        Assert.notNull((Object)details, (String)"'details' must not be null");
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        this.details = details;
        this.resourceLoader = resourceLoader;
        this.certificatesSupplier = LoadedPemSslStore.supplier(() -> LoadedPemSslStore.loadCertificates(details, resourceLoader));
        this.privateKeySupplier = LoadedPemSslStore.supplier(() -> LoadedPemSslStore.loadPrivateKey(details, resourceLoader));
    }

    private static <T> Supplier<T> supplier(ThrowingSupplier<T> supplier) {
        return SingletonSupplier.of((Supplier)supplier.throwing(LoadedPemSslStore::asUncheckedIOException));
    }

    private static UncheckedIOException asUncheckedIOException(String message, Exception cause) {
        return new UncheckedIOException(message, (IOException)cause);
    }

    private static CertificatesHolder loadCertificates(PemSslStoreDetails details, ResourceLoader resourceLoader) throws IOException {
        PemContent pemContent = PemContent.load(details.certificates(), resourceLoader);
        if (pemContent == null) {
            return new CertificatesHolder(null);
        }
        List<X509Certificate> certificates = pemContent.getCertificates();
        Assert.state((!CollectionUtils.isEmpty(certificates) ? 1 : 0) != 0, (String)"Loaded certificates are empty");
        return new CertificatesHolder(certificates);
    }

    private static PrivateKeyHolder loadPrivateKey(PemSslStoreDetails details, ResourceLoader resourceLoader) throws IOException {
        PemContent pemContent = PemContent.load(details.privateKey(), resourceLoader);
        return new PrivateKeyHolder(pemContent != null ? pemContent.getPrivateKey(details.privateKeyPassword()) : null);
    }

    @Override
    public @Nullable String type() {
        return this.details.type();
    }

    @Override
    public @Nullable String alias() {
        return this.details.alias();
    }

    @Override
    public @Nullable String password() {
        return this.details.password();
    }

    @Override
    public @Nullable List<X509Certificate> certificates() {
        return this.certificatesSupplier.get().certificates();
    }

    @Override
    public @Nullable PrivateKey privateKey() {
        return this.privateKeySupplier.get().privateKey();
    }

    @Override
    public PemSslStore withAlias(@Nullable String alias) {
        return new LoadedPemSslStore(this.details.withAlias(alias), this.resourceLoader);
    }

    @Override
    public PemSslStore withPassword(@Nullable String password) {
        return new LoadedPemSslStore(this.details.withPassword(password), this.resourceLoader);
    }

    private record CertificatesHolder(@Nullable List<X509Certificate> certificates) {
    }

    private record PrivateKeyHolder(@Nullable PrivateKey privateKey) {
    }
}

