/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.security.KeyStore;
import org.jspecify.annotations.Nullable;
import org.springframework.core.style.ToStringCreator;

public interface SslStoreBundle {
    public static final SslStoreBundle NONE = SslStoreBundle.of(null, null, null);

    public @Nullable KeyStore getKeyStore();

    public @Nullable String getKeyStorePassword();

    public @Nullable KeyStore getTrustStore();

    public static SslStoreBundle of(final @Nullable KeyStore keyStore, final @Nullable String keyStorePassword, final @Nullable KeyStore trustStore) {
        return new SslStoreBundle(){

            @Override
            public @Nullable KeyStore getKeyStore() {
                return keyStore;
            }

            @Override
            public @Nullable KeyStore getTrustStore() {
                return trustStore;
            }

            @Override
            public @Nullable String getKeyStorePassword() {
                return keyStorePassword;
            }

            public String toString() {
                ToStringCreator creator = new ToStringCreator((Object)this);
                creator.append("keyStore.type", (Object)(keyStore != null ? keyStore.getType() : "none"));
                creator.append("keyStorePassword", (Object)(keyStorePassword != null ? "******" : null));
                creator.append("trustStore.type", (Object)(trustStore != null ? trustStore.getType() : "none"));
                return creator.toString();
            }
        };
    }
}

