/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.ansi.AnsiPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class ResourceBanner
implements Banner {
    private static final Log logger = LogFactory.getLog(ResourceBanner.class);
    private final Resource resource;

    public ResourceBanner(Resource resource) {
        Assert.notNull((Object)resource, (String)"'resource' must not be null");
        Assert.isTrue((boolean)resource.exists(), (String)"'resource' must exist");
        this.resource = resource;
    }

    @Override
    public void printBanner(Environment environment, @Nullable Class<?> sourceClass, PrintStream out) {
        try (InputStream input = this.resource.getInputStream();){
            String banner = StreamUtils.copyToString((InputStream)input, (Charset)((Charset)environment.getProperty("spring.banner.charset", Charset.class, (Object)StandardCharsets.UTF_8)));
            for (PropertyResolver resolver : this.getPropertyResolvers(environment, sourceClass)) {
                banner = resolver.resolvePlaceholders(banner);
            }
            out.println(banner);
        }
        catch (Exception ex) {
            logger.warn((Object)LogMessage.format((String)"Banner not printable: %s (%s: '%s')", (Object)this.resource, ex.getClass(), (Object)ex.getMessage()), (Throwable)ex);
        }
    }

    protected List<PropertyResolver> getPropertyResolvers(Environment environment, @Nullable Class<?> sourceClass) {
        ArrayList<PropertyResolver> resolvers = new ArrayList<PropertyResolver>();
        resolvers.add((PropertyResolver)new PropertySourcesPropertyResolver((PropertySources)this.createNullDefaultSources(environment, sourceClass)));
        resolvers.add((PropertyResolver)new PropertySourcesPropertyResolver((PropertySources)this.createEmptyDefaultSources(environment, sourceClass)));
        return resolvers;
    }

    private MutablePropertySources createNullDefaultSources(Environment environment, @Nullable Class<?> sourceClass) {
        MutablePropertySources nullDefaultSources = new MutablePropertySources();
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
            configurableEnvironment.getPropertySources().forEach(arg_0 -> ((MutablePropertySources)nullDefaultSources).addLast(arg_0));
        }
        nullDefaultSources.addLast((PropertySource)this.getTitleSource(sourceClass, null));
        nullDefaultSources.addLast((PropertySource)this.getAnsiSource());
        nullDefaultSources.addLast((PropertySource)this.getVersionSource(environment, null));
        return nullDefaultSources;
    }

    private MutablePropertySources createEmptyDefaultSources(Environment environment, @Nullable Class<?> sourceClass) {
        MutablePropertySources emptyDefaultSources = new MutablePropertySources();
        emptyDefaultSources.addLast((PropertySource)this.getTitleSource(sourceClass, ""));
        emptyDefaultSources.addLast((PropertySource)this.getVersionSource(environment, ""));
        return emptyDefaultSources;
    }

    private MapPropertySource getTitleSource(@Nullable Class<?> sourceClass, @Nullable String defaultValue) {
        String applicationTitle = this.getApplicationTitle(sourceClass);
        Map<String, String> titleMap = Collections.singletonMap("application.title", applicationTitle != null ? applicationTitle : defaultValue);
        return new MapPropertySource("title", titleMap);
    }

    protected @Nullable String getApplicationTitle(@Nullable Class<?> sourceClass) {
        Package sourcePackage = sourceClass != null ? sourceClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationTitle() : null;
    }

    private AnsiPropertySource getAnsiSource() {
        return new AnsiPropertySource("ansi", true);
    }

    private MapPropertySource getVersionSource(Environment environment, @Nullable String defaultValue) {
        return new MapPropertySource("version", this.getVersionsMap(environment, defaultValue));
    }

    private Map<String, Object> getVersionsMap(Environment environment, @Nullable String defaultValue) {
        String appVersion = this.getApplicationVersion(environment);
        String bootVersion = this.getBootVersion();
        HashMap<String, Object> versions = new HashMap<String, Object>();
        versions.put("application.version", this.getVersionString(appVersion, false, defaultValue));
        versions.put("spring-boot.version", this.getVersionString(bootVersion, false, defaultValue));
        versions.put("application.formatted-version", this.getVersionString(appVersion, true, defaultValue));
        versions.put("spring-boot.formatted-version", this.getVersionString(bootVersion, true, defaultValue));
        return versions;
    }

    private @Nullable String getApplicationVersion(Environment environment) {
        return environment.getProperty("spring.application.version");
    }

    protected String getBootVersion() {
        return SpringBootVersion.getVersion();
    }

    private @Nullable String getVersionString(@Nullable String version, boolean format, @Nullable String fallback) {
        if (version == null) {
            return fallback;
        }
        return format ? " (v" + version + ")" : version;
    }
}

