/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.event.KeyValuePair;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.json.WritableJson;
import org.springframework.boot.logging.structured.GraylogExtendedLogFormatProperties;
import org.springframework.boot.logging.structured.JsonWriterStructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class GraylogExtendedLogFormatStructuredLogFormatter
extends JsonWriterStructuredLogFormatter<ILoggingEvent> {
    private static final Log logger = LogFactory.getLog(GraylogExtendedLogFormatStructuredLogFormatter.class);
    private static final Pattern FIELD_NAME_VALID_PATTERN = Pattern.compile("^[\\w.\\-]*$");
    private static final Set<String> ADDITIONAL_FIELD_ILLEGAL_KEYS = Set.of("id", "_id");

    GraylogExtendedLogFormatStructuredLogFormatter(Environment environment, ThrowableProxyConverter throwableProxyConverter, StructuredLoggingJsonMembersCustomizer<?> customizer) {
        super(members -> GraylogExtendedLogFormatStructuredLogFormatter.jsonMembers(environment, throwableProxyConverter, members), customizer);
    }

    private static void jsonMembers(Environment environment, ThrowableProxyConverter throwableProxyConverter, JsonWriter.Members<ILoggingEvent> members) {
        members.add("version", "1.1");
        members.add("short_message", ILoggingEvent::getFormattedMessage).as(GraylogExtendedLogFormatStructuredLogFormatter::getMessageText);
        members.add("timestamp", ILoggingEvent::getTimeStamp).as(GraylogExtendedLogFormatStructuredLogFormatter::formatTimeStamp);
        members.add("level", LevelToSyslogSeverity::convert);
        members.add("_level_name", ILoggingEvent::getLevel);
        members.add("_process_pid", (Long)environment.getProperty("spring.application.pid", Long.class)).when(Objects::nonNull);
        members.add("_process_thread_name", ILoggingEvent::getThreadName);
        GraylogExtendedLogFormatProperties.get(environment).jsonMembers(members);
        members.add("_log_logger", ILoggingEvent::getLoggerName);
        members.from(ILoggingEvent::getMDCPropertyMap).when(mdc -> !CollectionUtils.isEmpty((Map)mdc)).usingPairs((mdc, pairs) -> mdc.forEach((key, value) -> GraylogExtendedLogFormatStructuredLogFormatter.createAdditionalField(key, value, pairs)));
        members.from(ILoggingEvent::getKeyValuePairs).when(keyValuePairs -> !CollectionUtils.isEmpty((Collection)keyValuePairs)).usingPairs(GraylogExtendedLogFormatStructuredLogFormatter::createAdditionalField);
        members.add().whenNotNull(ILoggingEvent::getThrowableProxy).usingMembers(throwableMembers -> GraylogExtendedLogFormatStructuredLogFormatter.throwableMembers(throwableMembers, throwableProxyConverter));
    }

    private static String getMessageText(String formattedMessage) {
        return !StringUtils.hasText((String)formattedMessage) ? "(blank)" : formattedMessage;
    }

    private static WritableJson formatTimeStamp(long timeStamp) {
        return out -> out.append(new BigDecimal(timeStamp).movePointLeft(3).toPlainString());
    }

    private static void throwableMembers(JsonWriter.Members<ILoggingEvent> members, ThrowableProxyConverter throwableProxyConverter) {
        members.add("full_message", event -> GraylogExtendedLogFormatStructuredLogFormatter.formatFullMessageWithThrowable(throwableProxyConverter, event));
        members.add("_error_type", ILoggingEvent::getThrowableProxy).as(IThrowableProxy::getClassName);
        members.add("_error_stack_trace", arg_0 -> ((ThrowableProxyConverter)throwableProxyConverter).convert(arg_0));
        members.add("_error_message", ILoggingEvent::getThrowableProxy).as(IThrowableProxy::getMessage);
    }

    private static String formatFullMessageWithThrowable(ThrowableProxyConverter throwableProxyConverter, ILoggingEvent event) {
        return event.getFormattedMessage() + "\n\n" + throwableProxyConverter.convert(event);
    }

    private static void createAdditionalField(List<KeyValuePair> keyValuePairs, BiConsumer<Object, Object> pairs) {
        keyValuePairs.forEach(keyValuePair -> GraylogExtendedLogFormatStructuredLogFormatter.createAdditionalField(keyValuePair.key, keyValuePair.value, pairs));
    }

    private static void createAdditionalField(String name, Object value, BiConsumer<Object, Object> pairs) {
        Assert.notNull((Object)name, (String)"fieldName must not be null");
        if (!FIELD_NAME_VALID_PATTERN.matcher(name).matches()) {
            logger.warn((Object)LogMessage.format((String)"'%s' is not a valid field name according to GELF standard", (Object)name));
            return;
        }
        if (ADDITIONAL_FIELD_ILLEGAL_KEYS.contains(name)) {
            logger.warn((Object)LogMessage.format((String)"'%s' is an illegal field name according to GELF standard", (Object)name));
            return;
        }
        pairs.accept(GraylogExtendedLogFormatStructuredLogFormatter.asAdditionalFieldName(name), value);
    }

    private static Object asAdditionalFieldName(String name) {
        return !name.startsWith("_") ? "_" + name : name;
    }
}

