/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;

class ConversionServiceDeducer {
    private final ApplicationContext applicationContext;

    ConversionServiceDeducer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ConversionService getConversionService() {
        try {
            return (ConversionService)this.applicationContext.getBean("conversionService", ConversionService.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return ((Factory)this.applicationContext.getAutowireCapableBeanFactory().createBean(Factory.class)).create();
        }
    }

    private static class Factory {
        private List<Converter<?, ?>> converters = Collections.emptyList();
        private List<GenericConverter> genericConverters = Collections.emptyList();

        private Factory() {
        }

        @Autowired(required=false)
        @ConfigurationPropertiesBinding
        public void setConverters(List<Converter<?, ?>> converters) {
            this.converters = converters;
        }

        @Autowired(required=false)
        @ConfigurationPropertiesBinding
        public void setGenericConverters(List<GenericConverter> converters) {
            this.genericConverters = converters;
        }

        public ConversionService create() {
            if (this.converters.isEmpty() && this.genericConverters.isEmpty()) {
                return ApplicationConversionService.getSharedInstance();
            }
            ApplicationConversionService conversionService = new ApplicationConversionService();
            for (Converter<?, ?> converter : this.converters) {
                conversionService.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.genericConverters) {
                conversionService.addConverter(genericConverter);
            }
            return conversionService;
        }
    }
}

