/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.PropertyMapping;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ObjectUtils;

final class DefaultPropertyMapper
implements PropertyMapper {
    public static final PropertyMapper INSTANCE = new DefaultPropertyMapper();
    private LastMapping<ConfigurationPropertyName> lastMappedConfigurationPropertyName;
    private LastMapping<String> lastMappedPropertyName;

    private DefaultPropertyMapper() {
    }

    @Override
    public List<PropertyMapping> map(PropertySource<?> propertySource, ConfigurationPropertyName configurationPropertyName) {
        LastMapping<ConfigurationPropertyName> last = this.lastMappedConfigurationPropertyName;
        if (last != null && last.isFrom(configurationPropertyName)) {
            return last.getMapping();
        }
        String convertedName = configurationPropertyName.toString();
        List<PropertyMapping> mapping = Collections.singletonList(new PropertyMapping(convertedName, configurationPropertyName));
        this.lastMappedConfigurationPropertyName = new LastMapping<ConfigurationPropertyName>(configurationPropertyName, mapping);
        return mapping;
    }

    @Override
    public List<PropertyMapping> map(PropertySource<?> propertySource, String propertySourceName) {
        LastMapping<String> last = this.lastMappedPropertyName;
        if (last != null && last.isFrom(propertySourceName)) {
            return last.getMapping();
        }
        List<PropertyMapping> mapping = this.tryMap(propertySourceName);
        this.lastMappedPropertyName = new LastMapping<String>(propertySourceName, mapping);
        return mapping;
    }

    private List<PropertyMapping> tryMap(String propertySourceName) {
        try {
            ConfigurationPropertyName convertedName = ConfigurationPropertyName.adapt(propertySourceName, '.');
            if (!convertedName.isEmpty()) {
                PropertyMapping o = new PropertyMapping(propertySourceName, convertedName);
                return Collections.singletonList(o);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static class LastMapping<T> {
        private final T from;
        private final List<PropertyMapping> mapping;

        LastMapping(T from, List<PropertyMapping> mapping) {
            this.from = from;
            this.mapping = mapping;
        }

        public boolean isFrom(T from) {
            return ObjectUtils.nullSafeEquals(from, this.from);
        }

        public List<PropertyMapping> getMapping() {
            return this.mapping;
        }
    }
}

