/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessorRegistrar;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class EnableConfigurationPropertiesImportSelector
implements ImportSelector {
    EnableConfigurationPropertiesImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        Object[] type;
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(EnableConfigurationProperties.class.getName(), false);
        Object[] objectArray = type = attributes == null ? null : (Object[])attributes.getFirst((Object)"value");
        if (type == null || type.length == 0) {
            return new String[]{ConfigurationPropertiesBindingPostProcessorRegistrar.class.getName()};
        }
        return new String[]{ConfigurationPropertiesBeanRegistrar.class.getName(), ConfigurationPropertiesBindingPostProcessorRegistrar.class.getName()};
    }

    public static class ConfigurationPropertiesBeanRegistrar
    implements ImportBeanDefinitionRegistrar {
        public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(EnableConfigurationProperties.class.getName(), false);
            List<Class<?>> types = this.collectClasses((List)attributes.get((Object)"value"));
            for (Class<?> type : types) {
                String prefix = this.extractPrefix(type);
                String name = StringUtils.hasText((String)prefix) ? prefix + "-" + type.getName() : type.getName();
                if (this.containsBeanDefinition((ConfigurableListableBeanFactory)registry, name)) continue;
                this.registerBeanDefinition(registry, type, name);
            }
        }

        private String extractPrefix(Class<?> type) {
            ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(type, ConfigurationProperties.class);
            if (annotation != null) {
                return annotation.prefix();
            }
            return "";
        }

        private List<Class<?>> collectClasses(List<Object> list) {
            ArrayList result = new ArrayList();
            for (Object object : list) {
                for (Object value : (Object[])object) {
                    if (!(value instanceof Class) || value == Void.TYPE) continue;
                    result.add((Class)value);
                }
            }
            return result;
        }

        private void registerBeanDefinition(BeanDefinitionRegistry registry, Class<?> type, String name) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(type);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
            ConfigurationProperties properties = (ConfigurationProperties)AnnotationUtils.findAnnotation(type, ConfigurationProperties.class);
            Assert.notNull((Object)properties, (String)("No " + ConfigurationProperties.class.getSimpleName() + " annotation found on  '" + type.getName() + "'."));
        }

        private boolean containsBeanDefinition(ConfigurableListableBeanFactory beanFactory, String name) {
            boolean result = beanFactory.containsBeanDefinition(name);
            if (result) {
                return true;
            }
            if (beanFactory.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
                return this.containsBeanDefinition((ConfigurableListableBeanFactory)beanFactory.getParentBeanFactory(), name);
            }
            return false;
        }
    }
}

